/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AnwaltsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenErhoehungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GerichtsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.MehrfachPauschalTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrwertsteuerTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenZeile;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.KostenTragungsVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.data.tenordaten.VollstreckungsVerhaeltnis;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.interfaces.TenorVorbereitend;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;
import eu.gronos.kostenrechner.util.gebuehren.GebuehrenBerechnungPruefer;
import java.util.ArrayList;
import java.util.Arrays;

public class GebuehrenBerechnungsAufstellung
implements TenorVorbereitend {
    private static final String BESCHREIBUNG = "Berechnung von Geb\u00fchren";
    private static final String[] COLUMN_HEADERS = new String[]{"Geb\u00fchrentatbestand", "Satz", "Prozent (%)", "Geb\u00fchrenbetrag (EUR)"};
    private final ArrayList<GebuehrenTatbestand> values;
    private final Euro streitwert;
    private final TenorDatenContainer container;
    private BegruendungsZahlenTabelle zeilen;
    private StringBuilder gruende;
    private Pruefend<GebuehrenBerechnung> pruefer = new GebuehrenBerechnungPruefer();

    public GebuehrenBerechnungsAufstellung(VerfahrensDatenContainer verfahrensDaten) throws NullPointerException, IllegalArgumentException {
        GebuehrenBerechnung gebuehrenBerechnung = verfahrensDaten.gebuehrenBerechnung;
        this.pruefer.pruefeEingabe(gebuehrenBerechnung);
        this.values = new ArrayList();
        this.values.addAll(gebuehrenBerechnung.gebuehren);
        this.streitwert = gebuehrenBerechnung.streitwert;
        this.container = new TenorDatenContainer(verfahrensDaten);
    }

    @Override
    public String getGruende() {
        return this.gruende.toString();
    }

    @Override
    public EntscheidungsListenElemente<HauptsacheVerhaeltnis> erzeugeHauptsacheEntscheidung() {
        EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache = new EntscheidungsListenElemente<HauptsacheVerhaeltnis>();
        hauptsache.text = "";
        return hauptsache;
    }

    @Override
    public EntscheidungsListenElemente<KostenTragungsVerhaeltnis> erzeugeKostenEntscheidung() {
        EntscheidungsListenElemente<KostenTragungsVerhaeltnis> kostenEntscheidung = new EntscheidungsListenElemente<KostenTragungsVerhaeltnis>();
        kostenEntscheidung.text = "";
        return kostenEntscheidung;
    }

    @Override
    public EntscheidungsListenElemente<VollstreckungsVerhaeltnis> erzeugeVollstreckbarkeitsEntscheidung() {
        EntscheidungsListenElemente<VollstreckungsVerhaeltnis> vollEntscheidung = new EntscheidungsListenElemente<VollstreckungsVerhaeltnis>();
        vollEntscheidung.text = "";
        return vollEntscheidung;
    }

    @Override
    public StreitwertEntscheidungsElemente erzeugeStreitwertEntscheidung() {
        StreitwertEntscheidungsElemente swe = new StreitwertEntscheidungsElemente();
        swe.text = String.format("Der Streitwert wurde auf %s EUR festgesetzt.%n", this.streitwert);
        swe.streitwerte.add(this.streitwert);
        return swe;
    }

    @Override
    public EntscheidungsElemente erzeugeSonstigeEntscheidung() {
        EntscheidungsElemente sonstige = new EntscheidungsElemente();
        sonstige.text = this.berrechneGebuehrenAufstellung();
        return sonstige;
    }

    @Override
    public TenorDatenContainer erzeugeContainer() {
        this.container.berechnungsTyp = this.getBerechnungsTyp();
        this.container.hauptsacheEntscheidung = this.erzeugeHauptsacheEntscheidung();
        this.container.kostenEntscheidung = this.erzeugeKostenEntscheidung();
        this.container.vollstreckbarkeitsEntscheidung = this.erzeugeVollstreckbarkeitsEntscheidung();
        this.container.streitwertEntscheidung = this.erzeugeStreitwertEntscheidung();
        this.container.sonstigeEntscheidung = this.erzeugeSonstigeEntscheidung();
        this.container.begruendung = this.zeilen.toBegruendungsElemente(this.getGruende());
        this.container.allgemein.selectedPanel = 3;
        return this.container;
    }

    @Override
    public String getBerechnungsTyp() {
        return BESCHREIBUNG;
    }

    private String berrechneGebuehrenAufstellung() {
        Euro summe = Euro.ZERO_CENTS;
        Euro rvgsumme = Euro.ZERO_CENTS;
        this.zeilen = new BegruendungsZahlenTabelle();
        this.zeilen.add(Arrays.asList(COLUMN_HEADERS));
        for (GebuehrenTatbestand gt : this.values) {
            BegruendungsZahlenZeile zahlen = new BegruendungsZahlenZeile(3);
            if (gt instanceof MehrwertsteuerTatbestand) {
                zahlen.add(0.0);
                MehrwertsteuerTatbestand mwst = (MehrwertsteuerTatbestand)gt;
                Euro einzelposition = mwst.errechneSteuer(rvgsumme);
                zahlen.add(mwst.getSteuerSatz() * 100.0);
                summe = summe.add(einzelposition);
                zahlen.add(einzelposition);
                if (mwst.isIsoliert()) {
                    rvgsumme = Euro.ZERO_CENTS;
                }
                this.zeilen.add(gt.langBezeichnung(), zahlen);
                continue;
            }
            Euro einzelposition = GebuehrenAuflistung.errechneGebuehr(gt, this.streitwert);
            String ergaenzung = "";
            if (gt instanceof MehrfachPauschalTatbestand) {
                ergaenzung = String.format(" x %d %s", ((MehrfachPauschalTatbestand)gt).getAnzahl(), ((MehrfachPauschalTatbestand)gt).getEinheit());
            }
            if (gt instanceof GebuehrenErhoehungsTatbestand) {
                ergaenzung = String.format(" x %d", ((GebuehrenErhoehungsTatbestand)gt).getAnzahl());
            }
            boolean cfr_ignored_0 = gt instanceof GebuehrenSatzTatbestand;
            boolean cfr_ignored_1 = gt instanceof GebuehrenAnrechnungsTatbestand;
            if (gt instanceof GebuehrenSatzTatbestand) {
                zahlen.add(((GebuehrenSatzTatbestand)gt).getSatz());
            } else {
                zahlen.add(0.0);
            }
            zahlen.add(0.0);
            summe = summe.add(einzelposition);
            zahlen.add(einzelposition);
            if (gt.getGebuehrenKlasse() == AnwaltsGebuehrenTabelle.class) {
                rvgsumme = rvgsumme.add(GebuehrenAuflistung.errechneGebuehr(gt, this.streitwert));
            }
            this.zeilen.add(String.valueOf(gt.langBezeichnung()) + ergaenzung, zahlen);
        }
        BegruendungsZahlenZeile summenzahlen = new BegruendungsZahlenZeile();
        summenzahlen.add(0.0);
        summenzahlen.add(0.0);
        summenzahlen.add(summe);
        this.zeilen.add("Gesamt", summenzahlen);
        String summenFormat = "Danach fallen Geb\u00fchren in H\u00f6he von insgesamt %s EUR an.%n";
        this.baueGruende();
        return String.format("Danach fallen Geb\u00fchren in H\u00f6he von insgesamt %s EUR an.%n", summe);
    }

    private void baueGruende() {
        this.gruende = new StringBuilder();
        GebuehrenSatzTatbestand vv = new GebuehrenSatzTatbestand("", "", 1.0, AnwaltsGebuehrenTabelle.class);
        GebuehrenSatzTatbestand kv = new GebuehrenSatzTatbestand("", "", 1.0, GerichtsGebuehrenTabelle.class);
        this.gruende.append(String.format("Bei einem Streitwert von %s EUR betr\u00e4gt eine Gerichtsgeb\u00fchr %s EUR und eine Anwaltsgeb\u00fchr %s EUR. %nAufstellung: %n", this.streitwert, GebuehrenAuflistung.errechneGebuehr(kv, this.streitwert), GebuehrenAuflistung.errechneGebuehr(vv, this.streitwert)));
        this.zeilen.toStringBuilder(this.gruende);
    }
}

