/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.logic.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.Teilklageruecknahme;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.EntscheidungsListenElemente;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.HauptsacheVerhaeltnis;
import eu.gronos.kostenrechner.data.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.logic.TenorTexter;

public class StreitwertReduktionTexter
extends TenorTexter<Teilklageruecknahme> {
    private Euro[] streitwerte;

    public StreitwertReduktionTexter(boolean alsBruch) {
        super(alsBruch);
    }

    @Override
    public String texteHauptsache(EntscheidungsListenElemente<HauptsacheVerhaeltnis> hauptsache) {
        HauptsacheVerhaeltnis verhaeltnis = (HauptsacheVerhaeltnis)hauptsache.prozessverhaeltnisse.get(0);
        if (verhaeltnis.getVerurteilung().longValue() > 0L) {
            return this.satzBeginn(String.format("%s %s verurteilt, an %s %,.2f EUR zu zahlen.%s%n", verhaeltnis.getSchuldner().parteiBezeichner(Beteiligter.Casus.NOMINATIV, verhaeltnis.getSchuldner().getLfdNr(), true), this.getWirdWerden(verhaeltnis.getSchuldner().isPlural()), verhaeltnis.getGlaeubiger().parteiBezeichner(Beteiligter.Casus.AKKUSATIV, verhaeltnis.getGlaeubiger().getLfdNr(), true), verhaeltnis.getVerurteilung().doubleValue(), verhaeltnis.getVerurteilung().lessThan(this.streitwerte[1]) ? " Im \u00dcbrigen wird die Klage abgewiesen." : ""));
        }
        return "Die Klage wird abgewiesen.\n";
    }

    @Override
    public String texteStreitwert(StreitwertEntscheidungsElemente elemente) {
        return String.format("Der Streitwert wird auf %,.2f EUR bis zum ..., danach auf %,.2f EUR festgesetzt.%n", elemente.streitwerte.get(0).doubleValue(), elemente.streitwerte.get(1).doubleValue());
    }

    public void setStreitwerte(Euro[] streitwerte) {
        this.streitwerte = streitwerte;
    }
}

