/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.model.baumbach;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.RowHandler;
import eu.gronos.kostenrechner.interfaces.RowList;
import eu.gronos.kostenrechner.interfaces.TooltipLieferant;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BeteiligtenTableModel
extends AbstractTableModel
implements RowHandler<BaumbachBeteiligter>,
RowList<BaumbachBeteiligter>,
TooltipLieferant {
    private static final long serialVersionUID = -3535924357266123346L;
    protected BaumbachBeteiligtenListe values;
    protected final Beteiligter.BeteiligtenTyp beteiligtenTyp;
    private static final int COLUMN_COUNT = 4;
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Beteiligter.class, Euro.class, Euro.class, Boolean.class};
    private static final String[] COLUMN_NAMES = new String[]{"Beteiligte(r)", "H\u00f6he der Inanspruchnahme", "Verurteilung (Unterliegen)", "widerklagend/widerbeklagt"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Parteibezeichnung f\u00fcr den Beteiligten?", "In welcher H\u00f6he wurde der Beteiligte verklagt?", "In welcher H\u00f6he war die Klage gegen diesen Beteiligten erfolgreich (Unterliegen des Beteiligten)?", "Ist der Beteiligte an der Widerklage beteiligt?"};
    private boolean widerKlageAnzeigen;
    private int widerKlaegerIndex = -1;
    public static final String GESAMTSCHULDNERISCH = "gesamtschuldnerisch";
    protected static final int COLUMN_BETEILIGTER = 0;
    public static final int COLUMN_STREITWERT = 1;
    protected static final int COLUMN_UNTERLIEGEN = 2;
    protected static final int COLUMN_WIDERKLAGE = 3;

    public BeteiligtenTableModel(Beteiligter.BeteiligtenTyp beteiligtenTyp, boolean widerKlageAnzeigen) {
        this.beteiligtenTyp = beteiligtenTyp;
        this.values = new BaumbachBeteiligtenListe();
        this.widerKlageAnzeigen = widerKlageAnzeigen;
        this.setWiderklaegerIndex();
    }

    @Deprecated
    public BeteiligtenTableModel(int beteiligtenTyp, boolean widerKlageAnzeigen) {
        this(Beteiligter.BeteiligtenTyp.values()[beteiligtenTyp], widerKlageAnzeigen);
    }

    public BeteiligtenTableModel(Beteiligter.BeteiligtenTyp beteiligtenTyp, boolean widerKlageAnzeigen, BaumbachBeteiligtenListe values) {
        this(beteiligtenTyp, widerKlageAnzeigen);
        this.values = values;
    }

    @Deprecated
    public BeteiligtenTableModel(int beteiligtenTyp, boolean widerKlageAnzeigen, BaumbachBeteiligtenListe values) {
        this(beteiligtenTyp, widerKlageAnzeigen);
        this.values = values;
    }

    @Override
    public void addRow(BaumbachBeteiligter bt) throws IllegalArgumentException {
        if (this.getBeteiligtenTyp() == Beteiligter.BeteiligtenTyp.KLAEGER && this.getRowCount() > 0) {
            throw new IllegalArgumentException("Derzeit nur ein Kl\u00e4ger erlaubt.");
        }
        this.values.add(bt);
        int row = this.getRowCount() - 1;
        super.fireTableRowsInserted(row, row);
        if (this.getRowCount() == 2) {
            super.fireTableCellUpdated(0, 0);
        }
        this.setWiderklaegerIndex(row, ((BaumbachBeteiligter)this.values.get(row)).isAnWiderklageBeteiligt());
    }

    @Override
    public int getRowCount() {
        if (this.values != null) {
            return this.values.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        int zwischen = 4;
        if (this.beteiligtenTyp == Beteiligter.BeteiligtenTyp.KLAEGER && !this.widerKlageAnzeigen) {
            zwischen = 1;
        } else if (!this.widerKlageAnzeigen) {
            --zwischen;
        }
        return zwischen;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getRow(rowIndex);
            }
            case 1: {
                return this.getStreitwertAt(rowIndex);
            }
            case 2: {
                return this.getUnterliegenAt(rowIndex);
            }
            case 3: {
                return this.getWiderklageAt(rowIndex);
            }
        }
        return null;
    }

    public Beteiligter.BeteiligtenTyp getBeteiligtenTyp() {
        return this.beteiligtenTyp;
    }

    @Override
    public void removeRow(int rowIndex) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.values == null || rowIndex < 0 || this.values.size() - 1 < rowIndex) {
            return;
        }
        if (this.values.enthaeltGesamtschuldner() && !this.values.isGesamtschuldnerschaft(rowIndex)) {
            throw new IllegalArgumentException("Einzelne Beteiligte k\u00f6nnen nicht entfernt werden, solange noch eine gesamtschuldnerische Verurteilung vorliegt.");
        }
        this.values.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
        if (this.getRowCount() == 1) {
            super.fireTableCellUpdated(0, 0);
        }
        this.setWiderklaegerIndex();
        Kostenrechner.getLogger().info(String.format("widerKlaegerIndex: %d", this.widerKlaegerIndex));
    }

    @Override
    public BaumbachBeteiligter getRow(int rowIndex) throws IndexOutOfBoundsException {
        return (BaumbachBeteiligter)this.values.get(rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            String zwischen = Beteiligter.parteiBezeichner(this.beteiligtenTyp, Beteiligter.GenusNumerus.MAENNLICH_PLURAL, -1, Beteiligter.Casus.NOMINATIV, true);
            return String.valueOf(zwischen.substring(4, zwischen.length())) + "-Bezeichnung";
        }
        if (columnIndex == 3) {
            if (this.beteiligtenTyp == Beteiligter.BeteiligtenTyp.BEKLAGTE) {
                return "widerklagend";
            }
            return "widerbeklagt";
        }
        if (columnIndex < this.getColumnCount()) {
            return COLUMN_NAMES[columnIndex];
        }
        return super.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < this.getColumnCount()) {
            return COLUMN_CLASSES[columnIndex];
        }
        return super.getColumnClass(columnIndex);
    }

    public void setWiderKlageAnzeigen(boolean widerKlageAnzeigen) {
        if (this.widerKlageAnzeigen != widerKlageAnzeigen) {
            this.widerKlageAnzeigen = widerKlageAnzeigen;
            super.fireTableStructureChanged();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.values.enthaeltGesamtschuldner()) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return this.getBeteiligtenTyp() != Beteiligter.BeteiligtenTyp.KLAEGER || this.values.isAnWiderklageBeteiligt(rowIndex);
            }
            case 2: {
                return this.getBeteiligtenTyp() != Beteiligter.BeteiligtenTyp.KLAEGER || this.values.isAnWiderklageBeteiligt(rowIndex);
            }
            case 3: {
                return this.getBeteiligtenTyp() != Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        boolean erfolgreich = false;
        switch (columnIndex) {
            case 0: {
                erfolgreich = this.setParteiBezeichnerAt(aValue, rowIndex);
                break;
            }
            case 1: {
                erfolgreich = this.setStreitwertAt(aValue, rowIndex);
                break;
            }
            case 2: {
                erfolgreich = this.setUnterliegenAt(aValue, rowIndex);
                break;
            }
            case 3: {
                erfolgreich = this.setWiderklageAt(aValue, rowIndex);
                break;
            }
            default: {
                erfolgreich = false;
            }
        }
        if (erfolgreich) {
            super.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public BaumbachBeteiligtenListe getAllValues() {
        return this.values;
    }

    public BaumbachBeteiligter[] toArray() {
        if (this.values != null) {
            BaumbachBeteiligter[] array = new BaumbachBeteiligter[this.values.size()];
            array = this.values.toArray(array);
            return array;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.values == null) {
            this.values = new BaumbachBeteiligtenListe();
        } else {
            this.values.clear();
        }
        this.widerKlaegerIndex = -1;
        this.fireTableDataChanged();
    }

    @Override
    public String getTooltipText(int columnIndex) {
        if (columnIndex < 0 || columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        return COLUMN_TOOLTIPS[columnIndex];
    }

    @Override
    public void addAll(List<BaumbachBeteiligter> c) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private Boolean getWiderklageAt(int rowIndex) {
        if (this.values == null) {
            return null;
        }
        return this.values.isAnWiderklageBeteiligt(rowIndex);
    }

    private Euro getUnterliegenAt(int rowIndex) {
        if (this.values == null) {
            return null;
        }
        return this.values.getUnterliegenFor(rowIndex, false, false);
    }

    private Euro getStreitwertAt(int rowIndex) {
        if (this.values == null) {
            return null;
        }
        return this.values.getStreitwertFor(rowIndex);
    }

    boolean isWiderKlageAnzeigen() {
        return this.widerKlageAnzeigen;
    }

    protected boolean setWiderklageAt(Object aValue, int rowIndex) {
        if (aValue != null && aValue instanceof Boolean && !this.values.isGesamtschuldnerschaft(rowIndex) && this.beteiligtenTyp != Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE) {
            BaumbachBeteiligter zwischen = (BaumbachBeteiligter)this.values.get(rowIndex);
            boolean b = (Boolean)aValue;
            if (!b && this.beteiligtenTyp == Beteiligter.BeteiligtenTyp.KLAEGER) {
                this.setValueAt(new Double(0.0), rowIndex, 2);
                this.setValueAt(new Double(0.0), rowIndex, 1);
            }
            if (this.beteiligtenTyp == Beteiligter.BeteiligtenTyp.BEKLAGTE) {
                this.setWiderklaegerIndex(rowIndex, b);
            }
            zwischen.setAnWiderklageBeteiligt(b);
            return true;
        }
        return false;
    }

    private void setWiderklaegerIndex(int rowIndex, boolean anWiderklageBeteiligt) {
        if (this.beteiligtenTyp != Beteiligter.BeteiligtenTyp.BEKLAGTE) {
            return;
        }
        if (anWiderklageBeteiligt) {
            this.widerKlaegerIndex = rowIndex;
            this.markierWiderklaeger();
        } else if (this.widerKlaegerIndex == rowIndex) {
            this.widerKlaegerIndex = -1;
        }
    }

    private void setWiderklaegerIndex() {
        if (this.beteiligtenTyp != Beteiligter.BeteiligtenTyp.BEKLAGTE) {
            this.widerKlaegerIndex = -1;
            return;
        }
        if (!this.values.enthaeltAnWiderklageBeteiligte()) {
            this.widerKlaegerIndex = -1;
        } else {
            int row = 0;
            while (row < this.getRowCount()) {
                BaumbachBeteiligter baumbachBeteiligter = (BaumbachBeteiligter)this.values.get(row);
                if (baumbachBeteiligter.isAnWiderklageBeteiligt()) {
                    this.widerKlaegerIndex = row;
                }
                ++row;
            }
        }
    }

    private void markierWiderklaeger() {
        if (this.beteiligtenTyp != Beteiligter.BeteiligtenTyp.BEKLAGTE) {
            return;
        }
        int row = 0;
        while (row < this.getRowCount()) {
            boolean bisher;
            boolean neu = bisher = this.getWiderklageAt(row).booleanValue();
            BaumbachBeteiligter baumbachBeteiligter = (BaumbachBeteiligter)this.values.get(row);
            if (baumbachBeteiligter.getTyp() == Beteiligter.BeteiligtenTyp.BEKLAGTE && !baumbachBeteiligter.isGesamtschuldnerschaft()) {
                neu = row == this.widerKlaegerIndex;
                baumbachBeteiligter.setAnWiderklageBeteiligt(neu);
            }
            if (bisher != neu) {
                this.fireTableCellUpdated(row, 3);
            }
            ++row;
        }
    }

    protected boolean setUnterliegenAt(Object aValue, int rowIndex) {
        if (aValue != null && aValue instanceof Euro && !this.values.isGesamtschuldnerschaft(rowIndex)) {
            BaumbachBeteiligter zwischen = (BaumbachBeteiligter)this.values.get(rowIndex);
            Euro e = (Euro)aValue;
            if (e.greaterThan(this.getStreitwertAt(rowIndex))) {
                return false;
            }
            zwischen.setErfolg(e);
            return true;
        }
        return false;
    }

    protected boolean setStreitwertAt(Object aValue, int rowIndex) {
        if (aValue != null && aValue instanceof Euro && !this.values.isGesamtschuldnerschaft(rowIndex)) {
            BaumbachBeteiligter zwischen = (BaumbachBeteiligter)this.values.get(rowIndex);
            Euro e = (Euro)aValue;
            if (this.getUnterliegenAt(rowIndex).greaterThan(e)) {
                return false;
            }
            zwischen.setAntrag(e);
            return true;
        }
        return false;
    }

    protected boolean setParteiBezeichnerAt(Object aValue, int rowIndex) {
        BaumbachBeteiligter zwischen = (BaumbachBeteiligter)this.values.get(rowIndex);
        if (aValue != null && aValue instanceof Beteiligter && !zwischen.isGesamtschuldnerschaft()) {
            Beteiligter value = (Beteiligter)aValue;
            ((BaumbachBeteiligter)this.values.get(rowIndex)).setGenusNumerus(value.getGenusNumerus());
            return true;
        }
        return false;
    }
}

