/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util;

import eu.gronos.kostenrechner.data.tenordaten.BegruendungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.BegruendungsZahlenZeile;
import eu.gronos.kostenrechner.data.tenordaten.CaretRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BegruendungsZahlenTabelle {
    private final CaretRange range;
    private final List<BegruendungsZahlenZeile> zahlenZeilen;
    private final List<String> columnHeaders;
    private final List<String> rowHeaders;
    private int[] columnWeight = null;
    private int tableWeight = -1;

    public BegruendungsZahlenTabelle() {
        this.range = new CaretRange();
        this.zahlenZeilen = new ArrayList<BegruendungsZahlenZeile>();
        this.columnHeaders = new ArrayList<String>();
        this.rowHeaders = new ArrayList<String>();
    }

    public BegruendungsZahlenTabelle(List<BegruendungsZahlenZeile> doubleValues, List<String> columnHeaders, List<String> rowHeaders, CaretRange range) {
        this.range = range;
        this.zahlenZeilen = new ArrayList<BegruendungsZahlenZeile>(doubleValues);
        this.columnHeaders = new ArrayList<String>(columnHeaders);
        this.rowHeaders = new ArrayList<String>(rowHeaders);
    }

    public Object[][] toTableCellValues() {
        if (this.zahlenZeilen == null || this.columnHeaders == null || this.rowHeaders == null || this.zahlenZeilen.size() < 1 || this.columnHeaders.size() < 1 || this.rowHeaders.size() < 1) {
            return null;
        }
        if (this.zahlenZeilen.size() != this.rowHeaders.size()) {
            throw new IllegalArgumentException("doubleValues und rowHeaders m\u00fcssen gleich viele Zeilen haben!");
        }
        Object[][] tableCellValues = new Object[this.zahlenZeilen.size()][this.columnHeaders.size()];
        int row = 0;
        while (row < this.zahlenZeilen.size()) {
            tableCellValues[row][0] = this.rowHeaders.get(row);
            int column = 1;
            while (column < this.columnHeaders.size()) {
                BegruendungsZahlenZeile numberRow = this.zahlenZeilen.get(row);
                if (numberRow != null && numberRow.size() > column - 1) {
                    tableCellValues[row][column] = numberRow.get(column - 1);
                } else {
                    System.out.printf("Null oder IndexOutOfBounds bei (%d, %d)!%n", row, column);
                }
                ++column;
            }
            ++row;
        }
        return tableCellValues;
    }

    public String[] toColumnHeaders() {
        if (this.columnHeaders == null || this.columnHeaders.isEmpty()) {
            return null;
        }
        String[] array = new String[this.columnHeaders.size()];
        return this.columnHeaders.toArray(array);
    }

    public List<String> getColumnHeaders() {
        if (this.columnHeaders == null || this.columnHeaders.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(this.columnHeaders);
    }

    public List<String> getRowHeaders() {
        if (this.rowHeaders == null || this.rowHeaders.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(this.rowHeaders);
    }

    public List<BegruendungsZahlenZeile> getDoubleData() {
        if (this.zahlenZeilen == null || this.zahlenZeilen.isEmpty()) {
            return null;
        }
        return this.zahlenZeilen;
    }

    public Class<?>[] toColumnClasses() {
        if (this.columnHeaders == null || this.columnHeaders.size() < 1) {
            return null;
        }
        Class[] columnClasses = new Class[this.columnHeaders.size()];
        columnClasses[0] = String.class;
        int i = 1;
        while (i < this.columnHeaders.size()) {
            columnClasses[i] = Number.class;
            ++i;
        }
        return columnClasses;
    }

    public StringBuilder toStringBuilder(StringBuilder gruende) {
        this.range.beginn = gruende.length() - 1;
        int index = 0;
        while (index < this.columnHeaders.size()) {
            gruende.append(this.columnHeaders.get(index));
            if (index == this.columnHeaders.size() - 1) {
                gruende.append("\n");
            } else {
                gruende.append("\t");
            }
            ++index;
        }
        index = 0;
        while (index < this.zahlenZeilen.size()) {
            gruende.append(this.rowToText(index));
            ++index;
        }
        this.range.ende = gruende.length() - 1;
        return gruende;
    }

    public boolean add(List<String> values) {
        return this.columnHeaders.addAll(values);
    }

    public boolean add(String header, BegruendungsZahlenZeile values) {
        if (header == null || values == null) {
            throw new NullPointerException();
        }
        return this.rowHeaders.add(header) && this.zahlenZeilen.add(new BegruendungsZahlenZeile(values));
    }

    public CaretRange getRange() {
        return this.range;
    }

    public BegruendungsElemente toBegruendungsElemente(String gruende) {
        BegruendungsElemente begruendung = new BegruendungsElemente();
        begruendung.text = gruende;
        begruendung.range = this.getRange();
        begruendung.columnHeaders = this.getColumnHeaders();
        begruendung.rowHeaders = this.getRowHeaders();
        begruendung.zeilenZahlen = this.getDoubleData();
        return begruendung;
    }

    public int getColumnWeight(int index) {
        if (this.columnWeight == null) {
            return -1;
        }
        if (this.columnWeight.length - 1 < index) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        return this.columnWeight[index];
    }

    public int getTableWeight() {
        return this.tableWeight;
    }

    public void calculateTableWeight() {
        this.columnWeight = new int[this.columnHeaders.size()];
        this.tableWeight = 0;
        int index = 0;
        while (index < this.columnHeaders.size()) {
            this.gainWeight(index, this.columnHeaders.get(index).length());
            ++index;
        }
        index = 0;
        while (index < this.zahlenZeilen.size()) {
            this.gainWeight(0, this.rowHeaders.get(index).length());
            BegruendungsZahlenZeile row = this.zahlenZeilen.get(index);
            int cell = 0;
            while (cell < row.size()) {
                String cellText = this.cellText(row, cell);
                this.gainWeight(cell + 1, cellText.length());
                ++cell;
            }
            ++index;
        }
    }

    private String rowToText(int index) {
        if (this.zahlenZeilen == null || this.rowHeaders == null || this.zahlenZeilen.size() <= index || this.rowHeaders.size() <= index) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        text.append(this.rowHeaders.get(index));
        text.append("\t");
        text.append(this.zahlenZeilen.get(index).tabSeparatedValues());
        return text.toString();
    }

    private String cellText(BegruendungsZahlenZeile row, int cell) {
        return row.numberToSpalte((Number)row.get(cell));
    }

    private int gainWeight(int index, int weight) {
        this.columnWeight[index] = this.columnWeight[index] + weight;
        this.tableWeight += weight;
        return this.columnWeight[index];
    }
}

