/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util;

import eu.gronos.kostenrechner.data.tenordaten.BegruendungsElemente;
import eu.gronos.kostenrechner.data.tenordaten.CaretRange;
import eu.gronos.kostenrechner.data.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.interfaces.Tabulierend;
import eu.gronos.kostenrechner.interfaces.Tenorierend;
import eu.gronos.kostenrechner.util.BegruendungsZahlenTabelle;

public class TenorierendAdapter
implements Tenorierend,
Tabulierend {
    private final TenorDatenContainer container;
    private final BegruendungsZahlenTabelle zeilen;

    public TenorierendAdapter(TenorDatenContainer container) {
        this.container = container;
        BegruendungsElemente begruendung = container.begruendung;
        this.zeilen = new BegruendungsZahlenTabelle(begruendung.zeilenZahlen, begruendung.columnHeaders, begruendung.rowHeaders, begruendung.range);
    }

    @Override
    public Object[][] getTableCellValues() {
        return this.zeilen.toTableCellValues();
    }

    @Override
    public String[] getColumnHeaders() {
        return this.zeilen.toColumnHeaders();
    }

    @Override
    public CaretRange getRange() {
        return this.zeilen.getRange();
    }

    @Override
    public Class<?>[] getColumnClasses() {
        return this.zeilen.toColumnClasses();
    }

    @Override
    public String getGruende() {
        return this.container.begruendung.text;
    }

    @Override
    public String erzeugeTenor() {
        String tenor = String.valueOf(this.container.hauptsacheEntscheidung.text) + this.container.kostenEntscheidung.text + this.container.vollstreckbarkeitsEntscheidung.text + this.container.streitwertEntscheidung.text + this.container.sonstigeEntscheidung.text;
        return tenor;
    }

    @Override
    public String getTenorBeschreibung() {
        return this.container.berechnungsTyp;
    }

    @Override
    public int getTableWeight() {
        if (this.zeilen.getTableWeight() < 0) {
            this.zeilen.calculateTableWeight();
        }
        return this.zeilen.getTableWeight();
    }

    @Override
    public int getColumnWeight(int column) {
        if (this.zeilen.getColumnWeight(column) < 0) {
            this.zeilen.calculateTableWeight();
        }
        return this.zeilen.getColumnWeight(column);
    }
}

