/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VerlusteBank {
    private final Map<List<Beteiligter>, Euro> konten = new HashMap<List<Beteiligter>, Euro>();
    private Euro fiktiverStreitwert = Euro.ZERO_CENTS;

    public HtmlRtfFormattierend add(List<Beteiligter> beteiligte, Euro verlust) {
        Euro kontostand = this.konten.get(beteiligte);
        this.fiktiverStreitwert = this.fiktiverStreitwert.add(verlust);
        if (kontostand == null) {
            return this.konten.put(beteiligte, verlust);
        }
        return this.konten.put(beteiligte, kontostand.add(verlust));
    }

    public Euro get(List<Beteiligter> beteiligte) {
        return this.konten.get(beteiligte);
    }

    public double getQuotaFor(List<Beteiligter> beteiligte) {
        if (this.konten.get(beteiligte) == null || this.getFiktiverStreitwert().getCents() < 1L) {
            return 0.0;
        }
        return this.getFractionFor(beteiligte).doubleValue();
    }

    public Fraction getFractionFor(List<Beteiligter> beteiligte) {
        if (this.konten.get(beteiligte) == null || this.getFiktiverStreitwert().getCents() < 1L) {
            return Fraction.ZERO;
        }
        return this.konten.get(beteiligte).divideAsFraction(this.getFiktiverStreitwert());
    }

    public Set<List<Beteiligter>> keySet() {
        return this.konten.keySet();
    }

    public Euro getFiktiverStreitwert() {
        return this.fiktiverStreitwert;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fiktiverStreitwert.getCents() ^ this.fiktiverStreitwert.getCents() >>> 32);
        result = 31 * result + (this.konten == null ? 0 : this.konten.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VerlusteBank)) {
            return false;
        }
        VerlusteBank other = (VerlusteBank)obj;
        if (this.fiktiverStreitwert.getCents() != other.fiktiverStreitwert.getCents()) {
            return false;
        }
        return !(this.konten == null ? other.konten != null : !this.konten.equals(other.konten));
    }

    public void removeBlanks() {
        HashSet<List<Beteiligter>> keys = new HashSet<List<Beteiligter>>();
        for (List<Beteiligter> key : this.konten.keySet()) {
            if (this.konten.get(key) != null && this.konten.get(key).getCents() != 0L) continue;
            keys.add(key);
        }
        for (List<Beteiligter> key : keys) {
            this.konten.remove(key);
        }
    }
}

