/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.Pruefend;

public class BeteiligtenPruefer
implements Pruefend<BaumbachBeteiligter> {
    @Override
    public boolean pruefeEingabe(BaumbachBeteiligter eingabe) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        if (eingabe.getAntrag() == null) {
            throw new NullPointerException("antrag ist null bei " + eingabe.toString());
        }
        if (eingabe.getErfolg() == null) {
            throw new NullPointerException("erfolg ist null bei " + eingabe.toString());
        }
        if (eingabe.getAntrag().lessThan(eingabe.getErfolg())) {
            throw new NumberFormatException("Der Beteiligte kann nicht zu mehr verurteilt werden, als von ihm eingeklagt wurde!");
        }
        if (eingabe.getAntrag().lessThanOrEqualTo(Euro.ZERO_CENTS) && (Beteiligter.BeteiligtenTyp.KLAEGER != eingabe.getTyp() || eingabe.isAnWiderklageBeteiligt())) {
            throw new IllegalArgumentException("Der Streitwert muss \u00fcber 0 sein.");
        }
        if (Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE == eingabe.getTyp() && !eingabe.isAnWiderklageBeteiligt()) {
            throw new IllegalArgumentException("Ein Drittwiderbeklagter muss widerbeklagt sein!");
        }
        if (Beteiligter.BeteiligtenTyp.KLAEGER == eingabe.getTyp() && !eingabe.isAnWiderklageBeteiligt() && (eingabe.getAntrag().greaterThan(Euro.ZERO_CENTS) || eingabe.getErfolg().greaterThan(Euro.ZERO_CENTS))) {
            throw new IllegalArgumentException("Ein nicht widerbeklagter Kl\u00e4ger darf nicht in Anspruch genommen oder verurteilt werden (Streitwert oder Verurteilung d\u00fcrfen nicht gr\u00f6\u00dfer als 0 sein)!");
        }
        return true;
    }
}

