/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.files;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.KostenFileFilter;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.util.files.XmlDatei;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public class BerechnungXmlDatei
extends XmlDatei<VerfahrensDatenContainer> {
    protected static final String FEHLER_BEIM_LADEN_DER_XML_DATEI = "Fehler beim Laden der XML-Datei.";
    public static final String DATEIENDUNG = "skktx";
    public static final String DATEITYP = "Schusters kleiner Kostentenor XML-Dateien";
    private static final String SCHEMA_LOCATION = "https://www.kostentenor.de schema-skktx.xsd";
    public static final KostenFileFilter DATEI_FILTER = new KostenFileFilter("berechnung", String.format("%s (%s)", "Schusters kleiner Kostentenor XML-Dateien", "skktx"), "skktx");

    @Override
    public void speicherXml(VerfahrensDatenContainer container, Path datei) throws JAXBException, IOException {
        container.allgemein.speicherdatum = new XmlTransferHandler().speicherDatum();
        Marshaller marshaller = BerechnungXmlDatei.createMarshaller(true, this.getSchemaLocation());
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream out = Files.newOutputStream(datei, new OpenOption[0]);){
            marshaller.marshal((Object)container, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public VerfahrensDatenContainer ladeXml(Path datei) {
        VerfahrensDatenContainer container = null;
        try {
            container = this.unmarshalXml(datei);
            Kostenrechner.getLogger().info(String.format("Geladen als vdc: %s (%s)", datei.toAbsolutePath(), container.getClass()));
        }
        catch (IOException | NumberFormatException | JAXBException error) {
            FehlerHelper.zeigeFehler(FEHLER_BEIM_LADEN_DER_XML_DATEI, error);
            container = null;
        }
        if (container != null) {
            container.streitgenossen = this.fixGesamtschuldnerschaften(container.streitgenossen);
        }
        return container;
    }

    @Override
    public String toXmlString(VerfahrensDatenContainer container) {
        StringWriter sw = new StringWriter();
        try {
            Marshaller marshaller = BerechnungXmlDatei.createMarshaller(false, this.getSchemaLocation());
            marshaller.marshal((Object)container, sw);
        }
        catch (JAXBException e) {
            return "Programmzust\u00e4nde konnten nicht in XML konvertiert werden: " + e.getLocalizedMessage();
        }
        return sw.toString();
    }

    @Override
    public String getSchemaLocation() {
        return SCHEMA_LOCATION;
    }

    @Override
    public String getDateiendung() {
        return DATEIENDUNG;
    }

    protected Streitgenossen fixGesamtschuldnerschaften(Streitgenossen streitgenossen) {
        BaumbachBeteiligtenListe beklagte = streitgenossen.beklagte;
        if (beklagte.enthaeltGesamtschuldner()) {
            int index = 0;
            while (index < beklagte.size()) {
                if (beklagte.get(index) instanceof BaumbachGesamtschuldnerschaft) {
                    ((BaumbachGesamtschuldnerschaft)beklagte.get(index)).setBaumbachBeteiligtenListe(beklagte);
                }
                ++index;
            }
        }
        BaumbachBeteiligtenListe widerbeklagte = new BaumbachBeteiligtenListe();
        widerbeklagte.addAll(streitgenossen.klaeger);
        widerbeklagte.addAll(streitgenossen.drittwiderbeklagte);
        if (widerbeklagte.enthaeltGesamtschuldner()) {
            int index = 0;
            while (index < widerbeklagte.size()) {
                if (widerbeklagte.get(index) instanceof BaumbachGesamtschuldnerschaft) {
                    ((BaumbachGesamtschuldnerschaft)widerbeklagte.get(index)).setBaumbachBeteiligtenListe(widerbeklagte);
                }
                ++index;
            }
        }
        return streitgenossen;
    }

    private VerfahrensDatenContainer unmarshalXml(Path datei) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance(VerfahrensDatenContainer.class);
        Unmarshaller u = context.createUnmarshaller();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = Files.newInputStream(datei, new OpenOption[0]);){
            return (VerfahrensDatenContainer)u.unmarshal(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Marshaller createMarshaller(boolean formattedOutput, String schemaLocation) throws JAXBException, PropertyException {
        JAXBContext context = JAXBContext.newInstance(VerfahrensDatenContainer.class);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", new Boolean(formattedOutput));
        marshaller.setProperty("jaxb.schemaLocation", schemaLocation);
        return marshaller;
    }
}

