/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.files;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.tenordaten.CaretRange;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.data.tenordaten.Fraction;
import eu.gronos.kostenrechner.interfaces.HtmlRtfFormattierend;
import eu.gronos.kostenrechner.interfaces.Tabulierend;
import eu.gronos.kostenrechner.interfaces.Tenorierend;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RTFStringCreator {
    private String title;
    private String gruendeUeberschrift;
    private String tenor;
    private String gruende;
    private String arial;
    private static final String RTF_CREATIM_FORMAT = "{\\creatim\\yr%d\\mo%d\\dy%d\\hr%d\\min%d}%n";
    private static final String RTF_DOCCOMM_START = "{\\doccomm\n";
    private static final String RTF_TITLE_START = "{\\title\n";
    private static final String RTF_TAG_END = "}\n";
    private static final String RTF_INFO_START = "{\\info\n";
    private static final String RTF_FONT_DEF_START = "\\deff0{\\fonttbl{\\f0\\fswiss ";
    private static final String RTF_FONT_DEF_END = ";}}\n";
    private static final String RTF_STYLESHEET_START = "{\\stylesheet";
    private static final String RTF_STYLE_START = "{\\s";
    private static final String RTF_STYLE_BASEDON = "\\sbasedon0 ";
    private static final String RTF_STYLE_END = ";}";
    private static final String RTF_TABLE_ROW_START = "{\\trowd\\trgaph180";
    private static final String RTF_CELL_WIDTH_TAG = "\\cellx";
    private static final String RTF_TABLE_ROW_END = "\\row}\n";
    private static final String RTF_TABLE_CELL_START = "{\\pard\\intbl";
    private static final String RTF_TABLE_CELL_END = "\\cell}\n";
    private static final String RTF_BODY_START = "\\deflang1031\\plain\\fs24\\widowctrl\\hyphauto\\ftnbj";
    private static final String RTF_BASE_STYLE = "\\sa142\\sl320\\slmult1\\f0\\fs24\\qj";
    private static final String RTF_TABLE_STYLE = "\\sl320\\slmult1\\f0\\fs20\\qr";
    private static final String RTF_TABLE_HEADING_STYLE = "\\sl320\\slmult1\\f0\\fs20\\qc\\b";
    private static final String RTF_LINE_INDENT = "\\li1133";
    private static final String RTF_TENOR_STYLE = "\\li1133\\sa142\\sl320\\slmult1\\f0\\fs24\\qj";
    private static final String RTF_BOLD_CENTERED = "\\keepn\\qc\\b";
    private static final String RTF_HEADING_STYLE = "\\sa142\\sl320\\slmult1\\f0\\fs24\\qj\\keepn\\qc\\b";
    private static final String RTF_PARAGRAPH_START = "\n{\\pard";
    private static final String RTF_PARAGRAPH_END = "\\par}";
    private static final String RTF_TAB = "\\\\tab ";
    private static final int RTF_MAX_TABLE_WIDTH_TWIPS = 9600;
    private final boolean alsBruch;

    public RTFStringCreator(boolean alsBruch) {
        this.alsBruch = alsBruch;
    }

    public String createRTFString(Tenorierend tenorierend) throws UnsupportedEncodingException {
        StringBuilder rtfBuilder = this.createRtfStart();
        this.appendRtfHeader(rtfBuilder);
        this.appendRtfBody(rtfBuilder);
        if (tenorierend != null && tenorierend instanceof Tabulierend) {
            this.appendRtfReasons((Tabulierend)((Object)tenorierend), rtfBuilder);
        }
        String str = this.closeRtfBuilder(rtfBuilder);
        Map<String, String> dict = this.createDictionary(str);
        return this.unicodeReplace(str, dict);
    }

    private StringBuilder createRtfStart() {
        return new StringBuilder("{\\rtf1\\ansi\n");
    }

    private StringBuilder appendRtfHeader(StringBuilder rtfBuilder) {
        rtfBuilder.append(RTF_FONT_DEF_START + this.arial + RTF_FONT_DEF_END);
        rtfBuilder.append("{\\stylesheet\n");
        rtfBuilder.append("{\\s0 Standard;}");
        rtfBuilder.append("{\\s1\\sbasedon0 Tenor;}");
        rtfBuilder.append("{\\s2\\sbasedon0 \u00dc berschrift 1;}");
        rtfBuilder.append("{\\s3\\sbasedon0 Tabellenzelle;}");
        rtfBuilder.append("{\\s4\\sbasedon0 Tabellenkopf;}");
        rtfBuilder.append(RTF_TAG_END);
        String title = this.title.replaceAll("\\\\", " ");
        rtfBuilder.append(RTF_INFO_START);
        rtfBuilder.append(RTF_TITLE_START + title + RTF_TAG_END);
        LocalDateTime jetzt = LocalDateTime.now();
        rtfBuilder.append(String.format(RTF_CREATIM_FORMAT, jetzt.getYear(), jetzt.getMonthValue(), jetzt.getDayOfMonth(), jetzt.getHour(), jetzt.getMinute()));
        rtfBuilder.append(RTF_DOCCOMM_START + Kostenrechner.getInstance().getTitle() + RTF_TAG_END);
        rtfBuilder.append(RTF_TAG_END);
        return rtfBuilder;
    }

    private StringBuilder appendRtfBody(StringBuilder rtfBuilder) {
        rtfBuilder.append("\n\\deflang1031\\plain\\fs24\\widowctrl\\hyphauto\\ftnbj\n");
        rtfBuilder.append("{\\header\\pard\\plain \\sa142\\sl320\\slmult1\\f0\\fs24\\qj\\qr\\chpgn\\par}\n");
        this.appendParagraphs(rtfBuilder, this.tenor, "\\s1\\li1133\\sa142\\sl320\\slmult1\\f0\\fs24\\qj");
        return rtfBuilder;
    }

    private StringBuilder appendRtfReasons(Tabulierend tabulierend, StringBuilder rtfBuilder) {
        rtfBuilder.append("\n{\\pard\\s2\\sa142\\sl320\\slmult1\\f0\\fs24\\qj\\keepn\\qc\\b\n");
        rtfBuilder.append(this.getGruendeUeberschrift());
        rtfBuilder.append(RTF_PARAGRAPH_END);
        CaretRange range = tabulierend.getRange();
        String gruendeVorTabelle = this.gruende.substring(0, range.beginn);
        this.appendParagraphs(rtfBuilder, gruendeVorTabelle, "\\s0\\sa142\\sl320\\slmult1\\f0\\fs24\\qj");
        String gruendeTabelle = this.gruende.substring(range.beginn, range.ende);
        this.appendTableCells(rtfBuilder, gruendeTabelle, "\\s3\\sl320\\slmult1\\f0\\fs20\\qr", tabulierend);
        String gruendeNachTabelle = this.gruende.substring(range.ende, this.gruende.length());
        this.appendParagraphs(rtfBuilder, gruendeNachTabelle, "\\s0\\sa142\\sl320\\slmult1\\f0\\fs24\\qj");
        return rtfBuilder;
    }

    private String closeRtfBuilder(StringBuilder rtfBuilder) {
        rtfBuilder.append("\n}");
        return rtfBuilder.toString();
    }

    private StringBuilder appendParagraphs(StringBuilder rtfBuilder, String string, String formatting) {
        String[] paragraphs;
        String[] stringArray = paragraphs = string.split("\n");
        int n = paragraphs.length;
        int n2 = 0;
        while (n2 < n) {
            String paragraph = stringArray[n2];
            if (paragraph != null && !paragraph.isEmpty()) {
                rtfBuilder.append(RTF_PARAGRAPH_START + formatting + "\n");
                rtfBuilder.append(paragraph.replaceAll("\t", RTF_TAB).replaceAll("\u00a7 ", "\u00a7\\\\~"));
                rtfBuilder.append(RTF_PARAGRAPH_END);
            }
            ++n2;
        }
        return rtfBuilder;
    }

    private StringBuilder appendTableCells(StringBuilder rtfBuilder, String string, String formatting, Tabulierend tabulierend) {
        Object[][] tableCellValues;
        String startOfRow = this.cellWidthString(tabulierend);
        String headingFormatting = "\\s4\\sl320\\slmult1\\f0\\fs20\\qc\\b";
        String[] columnHeaders = tabulierend.getColumnHeaders();
        rtfBuilder.append(startOfRow).append("\\s4\\sl320\\slmult1\\f0\\fs20\\qc\\b");
        String[] stringArray = columnHeaders;
        int n = columnHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String headerCell = stringArray[n2];
            rtfBuilder.append(RTF_TABLE_CELL_START).append("\\s4\\sl320\\slmult1\\f0\\fs20\\qc\\b").append(" ").append(headerCell != null ? headerCell.replaceAll("\u00a7 ", "\u00a7\\\\~") : "").append(RTF_TABLE_CELL_END);
            ++n2;
        }
        rtfBuilder.append(RTF_TABLE_ROW_END);
        Object[][] objectArray = tableCellValues = tabulierend.getTableCellValues();
        int n3 = tableCellValues.length;
        n = 0;
        while (n < n3) {
            Object[] row = objectArray[n];
            if (row != null && row.length > 0) {
                rtfBuilder.append(startOfRow);
                String[] cells = this.convertRow(row);
                int column = 0;
                while (column < cells.length) {
                    String cell = cells[column];
                    rtfBuilder.append(RTF_TABLE_CELL_START).append(column == 0 ? "\\s4\\sl320\\slmult1\\f0\\fs20\\qc\\b" : formatting).append(" ").append(cell.replaceAll("\u00a7 ", "\u00a7\\\\~")).append(RTF_TABLE_CELL_END);
                    ++column;
                }
                rtfBuilder.append(RTF_TABLE_ROW_END);
            }
            ++n;
        }
        return rtfBuilder;
    }

    private String[] convertRow(Object[] paragraph) {
        String[] cells = new String[paragraph.length];
        int i = 0;
        while (i < cells.length && i < paragraph.length) {
            cells[i] = this.convertCell(paragraph[i]);
            ++i;
        }
        return cells;
    }

    private String convertCell(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Euro) {
            return ((HtmlRtfFormattierend)value).toRtfString();
        }
        if (value instanceof Fraction) {
            Fraction f = (Fraction)value;
            return this.alsBruch ? f.toRtfString() : f.toPercentString();
        }
        if (value instanceof Number) {
            return String.format("%,.2f", ((Number)value).doubleValue());
        }
        return Objects.toString(value);
    }

    private String cellWidthString(Tabulierend tabulierend) {
        String tableRowStart = RTF_TABLE_ROW_START;
        StringBuilder builder = new StringBuilder(RTF_TABLE_ROW_START);
        String cellWidthBeginning = RTF_CELL_WIDTH_TAG;
        int averageCellWidth = 9600 / tabulierend.getColumnClasses().length;
        int rightCellPos = 0;
        int i = 0;
        while (i < tabulierend.getColumnClasses().length) {
            int weightedCellWidth = 9600 * tabulierend.getColumnWeight(i) / tabulierend.getTableWeight();
            weightedCellWidth = (weightedCellWidth + averageCellWidth) / 2;
            builder.append(RTF_CELL_WIDTH_TAG + (rightCellPos += weightedCellWidth));
            ++i;
        }
        builder.append("\n");
        return builder.toString();
    }

    private String unicodeReplace(String str, Map<String, String> dict) {
        for (String key : dict.keySet()) {
            String value = dict.get(key);
            str = str.replaceAll(key, value);
        }
        return str;
    }

    private Map<String, String> createDictionary(String str) {
        HashMap<String, String> replace = new HashMap<String, String>();
        int i = 0;
        while (i < str.length()) {
            String bit = str.substring(i, i + 1);
            int value = str.codePointAt(i);
            if (value > 127) {
                replace.put("(" + bit + ")", "\\\\u" + value + "\\?");
            }
            if ("\\".equals(bit) && i + 3 < str.length() && "\\'".equals(str.substring(i, i + 2))) {
                bit = str.substring(i, i + 4);
                String hex = str.substring(i + 2, i + 4);
                try {
                    value = Integer.parseInt(hex, 16);
                    replace.put("\\\\\\'" + hex, "\\\\u" + value + "?");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return replace;
    }

    public void setTenor(String tenor) {
        this.tenor = tenor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGruende(String gruende) {
        this.gruende = gruende;
    }

    public void setGruendeUeberschrift(String gruendeUeberschrift) {
        this.gruendeUeberschrift = gruendeUeberschrift;
    }

    public String getGruendeUeberschrift() {
        return this.gruendeUeberschrift;
    }

    public void setArial(String arial) {
        this.arial = arial;
    }
}

