/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.files;

import eu.gronos.kostenrechner.util.files.StackTraceAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="error")
public class ThrowableWrapper {
    private String message;
    private String localizedMessage;
    private StackTraceElement[] stackTrace;
    private Throwable[] suppressed;
    private Throwable cause;

    public ThrowableWrapper() {
    }

    public ThrowableWrapper(Throwable error) {
        this();
        if (error != null) {
            if (error.getMessage() != null && error.getMessage().length() > "Exception".length()) {
                this.setMessage(error.getMessage());
            } else {
                this.setMessage(error.getClass().toString());
            }
            this.setLocalizedMessage(error.getLocalizedMessage());
            this.setStackTrace(error.getStackTrace());
        } else {
            this.setMessage(null);
            this.setLocalizedMessage(null);
            this.setStackTrace(null);
        }
    }

    @XmlAttribute(name="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlAttribute(name="localized")
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    public void setLocalizedMessage(String localizedMessage) {
        this.localizedMessage = localizedMessage;
    }

    @XmlElementWrapper(name="trace")
    @XmlElement(name="element")
    @XmlJavaTypeAdapter(value=StackTraceAdapter.class)
    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    @XmlElementWrapper(name="hintergrund")
    @XmlElement(name="suppressed")
    public List<String> getSuppressed() {
        if (this.suppressed == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Throwable[] throwableArray = this.suppressed;
        int n = this.suppressed.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable sup = throwableArray[n2];
            list.add(sup.toString());
            ++n2;
        }
        return list;
    }

    public void setSuppressed(Throwable[] suppressed) {
        this.suppressed = suppressed;
    }

    @XmlElement(name="cause")
    public String getCause() {
        if (this.cause == null) {
            return null;
        }
        return this.cause.toString();
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }
}

