/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.forderungen;

import eu.gronos.kostenrechner.data.forderungen.AufrechnungsForderung;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.data.forderungen.ForderungsStaffelung;
import eu.gronos.kostenrechner.data.forderungen.KlageForderung;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.util.forderungen.ForderungPruefer;
import java.util.List;

public class ForderungsStaffelungPruefer
implements Pruefend<ForderungsStaffelung> {
    @Override
    public boolean pruefeEingabe(ForderungsStaffelung eingabe) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        if (eingabe.forderungen == null || eingabe.forderungen.size() < 1) {
            throw new IllegalArgumentException("Die Liste der Forderungen darf nicht null oder leer sein!");
        }
        if (!this.isReihenfolgeEingehalten(eingabe.forderungen)) {
            throw new IllegalArgumentException("Die Reihenfolge (erst Klageforderungen, dann Aufrechnungsforderungen) ist nicht eingehalten!");
        }
        ForderungPruefer pruefer = new ForderungPruefer();
        for (Forderung forderung : eingabe.forderungen) {
            pruefer.pruefeEingabe(forderung);
        }
        return true;
    }

    private boolean isReihenfolgeEingehalten(List<Forderung> forderungen) {
        boolean antwort = true;
        boolean umstiegAufAufrechnung = false;
        if (!(forderungen.get(0) instanceof KlageForderung)) {
            antwort = false;
        }
        for (Forderung forderung : forderungen) {
            if (forderung instanceof AufrechnungsForderung) {
                umstiegAufAufrechnung = true;
            }
            if (!umstiegAufAufrechnung || !(forderung instanceof KlageForderung)) continue;
            antwort = false;
        }
        return antwort;
    }
}

