/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.Pruefend;
import eu.gronos.kostenrechner.util.gebuehren.GebuehrenPruefer;

public class GebuehrenBerechnungPruefer
implements Pruefend<GebuehrenBerechnung> {
    @Override
    public boolean pruefeEingabe(GebuehrenBerechnung eingabe) throws IllegalArgumentException, NullPointerException {
        if (eingabe.streitwert.lessThan(Euro.ZERO_CENTS)) {
            throw new IllegalArgumentException("Der Streitwert muss gr\u00f6\u00dfer/gleich 0 sein");
        }
        if (eingabe.gebuehren == null || eingabe.gebuehren.isEmpty()) {
            throw new NullPointerException("Die Liste der Tatbest\u00e4nde darf nicht leer (null) sein");
        }
        GebuehrenPruefer pruefer = new GebuehrenPruefer();
        for (GebuehrenTatbestand gt : eingabe.gebuehren) {
            pruefer.pruefeEingabe(gt);
        }
        return true;
    }
}

