/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.util.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenErhoehungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRahmenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrfachPauschalTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.Pruefend;

public class GebuehrenPruefer
implements Pruefend<GebuehrenTatbestand> {
    @Override
    public boolean pruefeEingabe(GebuehrenTatbestand eingabe) throws IllegalArgumentException, NumberFormatException, NullPointerException {
        if (eingabe instanceof MehrfachPauschalTatbestand) {
            if (((MehrfachPauschalTatbestand)eingabe).getAnzahl() < 0) {
                throw new NumberFormatException("Die Anzahl darf nicht negativ sein!");
            }
        } else if (eingabe instanceof AuslagenTatbestand) {
            if (((AuslagenTatbestand)eingabe).getBetrag() == null || ((AuslagenTatbestand)eingabe).getBetrag().compareTo(Euro.ofCents(0L)) < 0) {
                System.out.println("Betrag:" + ((AuslagenTatbestand)eingabe).getBetrag());
                throw new NumberFormatException("Die Auslagenh\u00f6he darf nicht negativ sein!");
            }
        } else if (eingabe instanceof PauschalTatbestand) {
            if (((PauschalTatbestand)eingabe).getBetrag() == null || ((PauschalTatbestand)eingabe).getBetrag().compareTo(Euro.ofCents(0L)) < 0) {
                throw new NumberFormatException(String.format("Bei einer %s darf der Betrag nicht negativ sein, hier %,.2f", "Pauschale", ((PauschalTatbestand)eingabe).getBetrag()));
            }
        } else if (eingabe instanceof GebuehrenErhoehungsTatbestand) {
            if (((GebuehrenErhoehungsTatbestand)eingabe).getAnzahl() < 0) {
                throw new NumberFormatException("Die Anzahl darf nicht negativ sein!");
            }
        } else if (eingabe instanceof GebuehrenAnrechnungsTatbestand) {
            GebuehrenAnrechnungsTatbestand grt = (GebuehrenAnrechnungsTatbestand)eingabe;
            if (Math.abs(grt.getSatz()) < Math.abs(grt.getUntergrenze()) || Math.abs(grt.getSatz()) > Math.abs(grt.getObergrenze())) {
                throw new NumberFormatException(String.format("Die angemessene Geb\u00fchr muss zwischen %,.2f- und %,.2f-fach liegen!", grt.getUntergrenze(), grt.getObergrenze()));
            }
        } else if (eingabe instanceof GebuehrenRahmenTatbestand) {
            GebuehrenRahmenTatbestand grt = (GebuehrenRahmenTatbestand)eingabe;
            if (grt.getSatz() < grt.getUntergrenze() || grt.getSatz() > grt.getObergrenze()) {
                throw new NumberFormatException(String.format("Die angemessene Geb\u00fchr muss zwischen %,.1f- und %,.1f-fach liegen!", grt.getUntergrenze(), grt.getObergrenze()));
            }
        } else if (eingabe instanceof GebuehrenSatzTatbestand && ((GebuehrenSatzTatbestand)eingabe).getSatz() < 0.0) {
            throw new NumberFormatException(String.format("Bei einem %s darf der Satz nicht negativ sein, hier %,.2f", "Geb\u00fchrensatz", ((GebuehrenSatzTatbestand)eingabe).getSatz()));
        }
        return true;
    }
}

