/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.BeschrifteterJDialog;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.HinzufuegenOkAction;
import eu.gronos.kostenrechner.controller.SprungmarkenHorcher;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.NumberFormatter;

public abstract class HinzufuegenDialog<E>
extends BeschrifteterJDialog {
    private static final long serialVersionUID = -6595384338088840389L;
    public static final String FEHLER_BT_UNTERLIEGEN_GT_STREITWERT = "Der Beteiligte kann nicht zu mehr verurteilt werden, als von ihm eingeklagt wurde!";
    public static final String FEHLER_WK_STREITWERT = "Bei einer Widerklage muss der Streitwert > 0 sein.";
    public static final String FEHLER_BK_STREITWERT = "Der Streitwert muss \u00fcber 0 sein.";
    public static final String FEHLER_ZAHLFORMAT_DWBK = "Ung\u00fcltiges Zahlformat bei der Anzahl der Drittwiderbeklagten";
    public static final String FEHLER_NIX_WIDERKLAEGER_WIDERBEKLAGTER = "Kein widerklagender Beklagter oder kein Widerbeklagter asugew\u00e4hlt!";
    public static final String FEHLER_UNTERLIEGEN_GT_STREITWERT = "Das Unterliegen darf nicht h\u00f6her als der Streitwert sein! Bei Gesamtschuldnern wird das gesamtschuldnerische Unterliegen mit ber\u00fccksichtigt.";
    public static final String FEHLER_ZAHLENFORMAT = "Fehler beim Konvertieren des Zahlenformats!";
    public static final String FEHLER_BK_GESAMTSCHULDNERSCHAFT = "Wenn Sie gesamtschuldnerische Verurteilung aktivieren, muss mehr als ein Beklagter markiert sein, die H\u00f6he der Verurteilung > 0 sein, aber maximal so hoch wie der Streitwert sein.";
    public static final String FEHLER_WK_GESAMTSCHULDNERSCHAFT = "Wenn Sie gesamtschuldnerische Verurteilung aktivieren, muss mehr als ein Widerbeklagter markiert sein, die H\u00f6he der Verurteilung > 0 sein, aber maximal so hoch wie der Streitwert sein.";
    public static final String FEHLER_ZAHLENFORMAT_SW = "Falches Zahlformat beim Streitwert!";
    public static final String FEHLER_KLAEGER_NIX_WBK = "Der ausgew\u00e4hlte Kl\u00e4ger ist nicht widerbeklagt.";
    public static final String FEHLER_ZAHLENFORMAT_KL_BK = "Falsches Zahlformat bei Kl\u00e4ger- oder Beklagtenanzahl! ";
    public static final String FEHLER_BEIM_ANLEGEN_KL_BK = "Fehler beim Anlegen der Kl\u00e4ger oder Beklagten! ";
    public static final String FEHLER_AUSLAGENHOEHE_NEGATIV = "Die Auslagenh\u00f6he darf nicht negativ sein!";
    public static final String FEHLER_ANZAHL_NEGATIV = "Die Anzahl darf nicht negativ sein!";
    public static final String FEHLER_ZAHLENFORMAT_WERT = "Falsches Eingabeformat beim Wert! ";
    public static final String FEHLER_BEGRUENDETHEIT_GT_WERT = "Eine Forderung kann nicht erfolgreicher sein als ihr Wert (ne ultra petita)!";
    public static final HyperlinkListener HYPERLINK_LISTENER = new SprungmarkenHorcher();
    private boolean ok = false;
    protected NumberFormatter formatter;
    private BeschriebeneAktion okAction;
    private JButton okButton;
    private boolean okButtonToBeFocussed = false;

    public HinzufuegenDialog(Window owner, Beschriftung beschriftung) throws HeadlessException {
        super(owner, beschriftung);
        Kostenrechner.getLogger().info("Starte Dialog " + this.getClass().toString());
        this.formatter = this.createNumberFormatter();
    }

    public abstract boolean parseEingabe();

    public E showDialogAndAsk() {
        super.showDialog();
        if (this.isOkButtonToBeFocussed()) {
            this.getOkButton().requestFocus();
        }
        if (this.isOk()) {
            return this.baueRueckgabewert();
        }
        return null;
    }

    public void performOkAction(ActionEvent ae) {
        this.okAction.actionPerformed(ae);
    }

    @Override
    public void fensterSchliessenBeiAbbruch() {
        this.setOk(false);
        super.fensterSchliessenBeiAbbruch();
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public boolean isOkButtonToBeFocussed() {
        return this.okButtonToBeFocussed;
    }

    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    protected abstract E baueRueckgabewert();

    protected void setOkButtonToBeFocussed(boolean okButtonToBeFocussed) {
        this.okButtonToBeFocussed = okButtonToBeFocussed;
    }

    protected AbstractAction getOkAction() {
        return this.okAction;
    }

    protected void setOkActionEnabled(boolean enabled) {
        this.okAction.setEnabled(enabled);
    }

    protected JButton getOkButton() {
        return this.okButton;
    }

    @Override
    protected void setButtonPane() {
        super.setButtonPane();
        super.changeCancelBeschriftung(0);
        if (this.okAction == null) {
            this.createOkAction();
        }
        this.setOkButton(this.okAction.toButton());
        this.addToRootInputMap(this.okAction);
        this.getButtonPane().add((Component)this.getOkButton(), 0);
        this.getRootPane().setDefaultButton(this.getOkButton());
    }

    private void createOkAction() {
        this.okAction = new HinzufuegenOkAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(76051));
    }

    private NumberFormatter createNumberFormatter() {
        NumberFormat format = DecimalFormat.getInstance(Locale.GERMAN);
        NumberFormatter formatter = new NumberFormatter(format);
        format.setGroupingUsed(false);
        formatter.setAllowsInvalid(true);
        return formatter;
    }
}

