/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.StringConfigSchluessel;
import eu.gronos.beschriftungen.util.StringConfigOption;
import eu.gronos.kostenrechner.controller.files.KostenFileFilter;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class KostenFileChooser
extends JFileChooser
implements AbfrageLieferant<JDialog> {
    private static Path speicherOrt;
    private static StringConfigOption speicherOrtOption;
    private static final long serialVersionUID = -8758824500337543760L;
    private final KostenFileFilter filter;
    private JDialog dialog2 = null;
    private ComponentBeschrifter beschrifter = new ComponentBeschrifter();
    private Beschriftung beschriftung;

    static {
        speicherOrtOption = new StringConfigOption(new StringConfigSchluessel("speicherOrt", ""));
    }

    public KostenFileChooser(KostenFileFilter filter, Beschriftung beschriftung) {
        this.filter = filter;
        this.beschriftung = beschriftung;
    }

    @Override
    public int showOpenDialog(Component parent) {
        this.setCurrentDirectory(this.getSpeicherOrt().toFile());
        this.setDialogType(0);
        int option = this.showDialog(parent);
        if (option == 0) {
            this.setSpeicherOrt(this.getCurrentDirectory().toPath());
        }
        return option;
    }

    @Override
    public int showSaveDialog(Component parent) {
        this.setCurrentDirectory(this.getSpeicherOrt().toFile());
        this.setDialogType(1);
        int option = this.showDialog(parent);
        Path datei = null;
        if (option == 0) {
            datei = this.getSelectedPath().toAbsolutePath();
            datei = this.filter.acceptAsPath(datei);
            this.setSelectedPath(datei);
            option = this.pruefeVorhandensein(datei);
            if (option == 0) {
                this.setSpeicherOrt(this.getCurrentDirectory().toPath());
            }
        }
        return option;
    }

    public Path getSelectedPath() {
        return super.getSelectedFile().toPath();
    }

    public void setSelectedPath(Path datei) {
        super.setSelectedFile(datei.toFile());
    }

    @Override
    @Deprecated
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    @Override
    @Deprecated
    public File getSelectedFile() {
        return super.getSelectedFile();
    }

    @Override
    public JDialog getDialog() {
        return this.dialog2;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        this.setMultiSelectionEnabled(false);
        this.setAcceptAllFileFilterUsed(false);
        this.addChoosableFileFilter(this.filter);
        this.setFileFilter(this.filter);
        this.setCurrentDirectory(this.getSpeicherOrt().toFile());
        if (this.filter.getPreSelected() != null) {
            this.setSelectedFile(new File(this.filter.getPreSelected()));
        }
        this.setDialog(super.createDialog(parent));
        if (this.beschriftung != null) {
            if (this.beschriftung instanceof Vorsorgend) {
                this.beschrifter.changeTo((Vorsorgend)((Object)this.beschriftung), this.getDialogType(), this.filter.getDescription());
            }
            this.beschrifter.beschrifte(this.getDialog(), this.beschriftung);
        }
        return this.getDialog();
    }

    protected void setDialog(JDialog dialog) {
        this.dialog2 = dialog;
    }

    protected Path getSpeicherOrt() {
        if (!(speicherOrt != null || Files.exists(speicherOrt = Paths.get((String)speicherOrtOption.getValue(), new String[0]), new LinkOption[0]) && Files.isDirectory(speicherOrt, new LinkOption[0]))) {
            speicherOrtOption.reset();
            speicherOrt = Paths.get((String)speicherOrtOption.getValue(), new String[0]);
        }
        return speicherOrt;
    }

    protected void setSpeicherOrt(Path pfad) {
        speicherOrt = pfad;
        speicherOrtOption.setValue(speicherOrt.toAbsolutePath().toString());
    }

    private int showDialog(Component parent) {
        int option = this.showDialog(parent, null);
        this.setDialog(null);
        return option;
    }

    private int pruefeVorhandensein(Path datei) {
        if (Files.exists(datei, new LinkOption[0])) {
            int bestaetigung = JOptionPane.showConfirmDialog(this, "Die Datei existiert schon. \n\nFortfahren?");
            if (bestaetigung == 0) {
                System.out.println("Zugestimmt");
                return 0;
            }
            JOptionPane.showMessageDialog(this, "Die Datei wurde nicht gespeichert.");
            return 1;
        }
        System.out.println("keine Zustimmung n\u00f6tig");
        return 0;
    }
}

