/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.BeschriebenesPanel;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.EintragEntfernenAktion;
import eu.gronos.kostenrechner.controller.NumberExtractor;
import eu.gronos.kostenrechner.controller.TabulatorBeforeAction;
import eu.gronos.kostenrechner.controller.TabulatorNextAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenTransferHandler;
import eu.gronos.kostenrechner.view.EuroEditor;
import eu.gronos.kostenrechner.view.EuroRenderer;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenTableRenderer;
import eu.gronos.kostenrechner.view.gebuehren.TooltipHeaderRenderer;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.NumberFormatter;

public abstract class KostenJPanel
extends BeschriebenesPanel {
    private static final String QUIT_EDIT_MODE_ACTION_NAME = "quitEditModeAction";
    private static final String EDIT_MODE_ACTION_NAME = "editModeAction";
    private static final String TAB_BEFORE_NAME = "tabBefore";
    private static final String TAB_NEXT_NAME = "tabNext";
    private static final long serialVersionUID = -6667909235024117172L;
    private final KeyStroke tabKey = KeyStroke.getKeyStroke(9, 0);
    private final KeyStroke shiftTabKey = KeyStroke.getKeyStroke(9, 64);
    private final KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    public final AbstractAction eintragEntfernenAktion = new EintragEntfernenAktion((LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(63105));
    AbstractAction aaTabNext = new TabulatorNextAction();
    AbstractAction aaTabBefore = new TabulatorBeforeAction();
    public static final NumberFormatter FORMATTER_INT = new NumberFormatter(NumberFormat.getIntegerInstance());
    public static final NumberFormat FORMAT = NumberFormat.getInstance();
    public static final NumberFormatter FORMATTER = new NumberFormatter(FORMAT);
    public static final TooltipHeaderRenderer HEADER_RENDERER = new TooltipHeaderRenderer();
    public static final EuroEditor EURO_EDITOR = new EuroEditor(FORMATTER);
    public static final EuroRenderer EURO_RENDERER = new EuroRenderer();
    private long start = 0L;
    private long ende = 0L;

    protected KostenJPanel() {
        super(new GridBagLayout());
        this.setStart(Kostenrechner.systemDefaultZone.millis());
        FORMAT.setGroupingUsed(false);
        Kostenrechner.getLogger().info("Starte JPanel " + this.getClass().toString());
    }

    public abstract void buildPanel();

    public abstract void setKostenrechner(Kostenrechner var1);

    public long getStart() {
        return this.start;
    }

    public long getEnde() {
        return this.ende;
    }

    public long errechneDauer() {
        if (this.getEnde() == 0L) {
            this.setEnde(Kostenrechner.systemDefaultZone.millis());
        }
        return this.getEnde() - this.getStart();
    }

    public void entferneTastaturFalle(JTable table) {
        table.getInputMap(0).put(this.tabKey, TAB_NEXT_NAME);
        table.getActionMap().put(TAB_NEXT_NAME, this.aaTabNext);
        table.getInputMap(0).put(this.shiftTabKey, TAB_BEFORE_NAME);
        table.getActionMap().put(TAB_BEFORE_NAME, this.aaTabBefore);
    }

    public void baueEditModeEin(JTable table) {
        EditModeAction editModeAction = new EditModeAction(table);
        table.getInputMap(1).put(this.enterKey, EDIT_MODE_ACTION_NAME);
        table.getActionMap().put(EDIT_MODE_ACTION_NAME, editModeAction);
        QuitEditModeAction quitEditModeAction = new QuitEditModeAction(table);
        table.getActionMap().put(QUIT_EDIT_MODE_ACTION_NAME, quitEditModeAction);
        table.addFocusListener(quitEditModeAction);
    }

    public void setzeGebuehrenTabelleAussehen(JTable table) {
        table.getColumnModel().getColumn(0).setMinWidth(180);
        table.getColumnModel().getColumn(0).setPreferredWidth(180);
        table.getColumnModel().getColumn(1).setPreferredWidth(40);
        table.getColumnModel().getColumn(2).setPreferredWidth(60);
        table.setDefaultRenderer(Double.class, new GebuehrenTableRenderer());
        table.getTableHeader().setDefaultRenderer(HEADER_RENDERER);
        table.setSelectionMode(0);
        table.setTransferHandler(new GebuehrenTransferHandler(table));
    }

    public void intoTabbedPane(JTabbedPane pane, Beschriftung beschriftung) throws IllegalArgumentException, IndexOutOfBoundsException {
        pane.addTab(beschriftung.getTitle(), null, this, beschriftung.getShortDescription());
        int index = pane.getTabCount() - 1;
        pane.setEnabledAt(index, true);
        pane.setMnemonicAt(index, beschriftung.getMnemonic());
        this.beschrifter.beschrifte(this, beschriftung);
    }

    protected void setStart(long start) {
        this.start = start;
    }

    protected void setEnde(long ende) {
        this.ende = ende;
    }

    protected void logDauer() {
        Kostenrechner.getLogger().info(String.format("%s brauchte: %d millis", this.getClass().toString(), this.errechneDauer()));
    }

    protected long longAusFormatter(JFormattedTextField fTf, String beschriftung) throws NumberFormatException {
        if (fTf == null) {
            return 0L;
        }
        return new NumberExtractor(fTf, beschriftung).extractLong();
    }

    public final class EditModeAction
    extends AbstractAction {
        private final JTable table;
        private static final long serialVersionUID = 1L;
        private final KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);

        public EditModeAction(JTable table) {
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.editMode();
        }

        private void editMode() {
            System.out.println("editing activated");
            this.table.setCellSelectionEnabled(true);
            InputMap input = this.table.getInputMap(1);
            input.remove(KostenJPanel.this.shiftTabKey);
            input.remove(KostenJPanel.this.tabKey);
            input.remove(KostenJPanel.this.enterKey);
            input.put(KostenJPanel.this.shiftTabKey, "selectPreviousColumnCell");
            input.put(KostenJPanel.this.tabKey, "selectNextColumnCell");
            input.put(this.escKey, KostenJPanel.QUIT_EDIT_MODE_ACTION_NAME);
            this.table.getActionMap().get("selectNextColumnCell").actionPerformed(new ActionEvent(this.table, 1001, "selectNextColumnCell"));
        }
    }

    public final class QuitEditModeAction
    extends AbstractAction
    implements FocusListener {
        private final JTable table;
        private static final long serialVersionUID = 1L;

        public QuitEditModeAction(JTable table) {
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.quitEditMode();
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.quitEditMode();
        }

        private void quitEditMode() {
            System.out.println("editing de-activated");
            this.table.setCellSelectionEnabled(false);
            int selectedColumn = this.table.getSelectedColumn();
            int selectedRow = this.table.getSelectedRow();
            this.table.setRowSelectionAllowed(true);
            if (selectedColumn > -1 && selectedRow > -1) {
                this.table.setRowSelectionInterval(selectedRow, selectedRow);
            }
            InputMap input = this.table.getInputMap(1);
            input.remove(KostenJPanel.this.shiftTabKey);
            input.remove(KostenJPanel.this.tabKey);
            input.put(KostenJPanel.this.shiftTabKey, KostenJPanel.TAB_BEFORE_NAME);
            input.put(KostenJPanel.this.tabKey, KostenJPanel.TAB_NEXT_NAME);
            input.put(KostenJPanel.this.enterKey, KostenJPanel.EDIT_MODE_ACTION_NAME);
        }
    }
}

