/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenListRenderer;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class BeteiligtenCellEditor
extends DefaultCellEditor
implements TableModelListener {
    private static final long serialVersionUID = -1251100602581421021L;
    public static final BeteiligtenListRenderer BETEILIGTEN_RENDERER_OHNE_LFDNR = new BeteiligtenListRenderer(true);
    private TableModel model;

    public BeteiligtenCellEditor(Beteiligter.BeteiligtenTyp typ) {
        super(BeteiligtenCellEditor.baueComboBox(typ));
    }

    @Deprecated
    public BeteiligtenCellEditor(int typ) {
        this(Beteiligter.BeteiligtenTyp.of(typ));
    }

    @Override
    public Object getCellEditorValue() {
        Object cellEditorValue = super.getCellEditorValue();
        this.remove();
        return cellEditorValue;
    }

    @Override
    public boolean stopCellEditing() {
        boolean stopCellEditing = super.stopCellEditing();
        this.remove();
        return stopCellEditing;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.remove();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.cancelCellEditing();
        ((AbstractTableModel)e.getSource()).removeTableModelListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.model = table.getModel();
        this.model.addTableModelListener(this);
        return component;
    }

    private static JComboBox<Beteiligter> baueComboBox(Beteiligter.BeteiligtenTyp typ) {
        JComboBox<Beteiligter> comboBox = new JComboBox<Beteiligter>(Beteiligter.getBeteiligtenAuswahlListe(typ, false));
        comboBox.setRenderer(BETEILIGTEN_RENDERER_OHNE_LFDNR);
        return comboBox;
    }

    private void remove() {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
    }
}

