/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.interfaces.Vorsorgend;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.controller.baumbach.BeteiligtenParser;
import eu.gronos.kostenrechner.controller.baumbach.WiderklageCheckboxTextfieldHorcher;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;

public class BeteiligtenHinzufuegenDialog
extends HinzufuegenDialog<BaumbachBeteiligter> {
    private static final long serialVersionUID = 2242125254034647717L;
    JComboBox<Beteiligter> cmbTypGenusNumerus;
    JCheckBox cbAnWiderklageBeteiligt;
    JFormattedTextField ftfStreitwert;
    JFormattedTextField ftfUnterliegen;
    final Beteiligter.BeteiligtenTyp beteiligtenTyp;
    final boolean widerKlageAnzeigen;
    private BaumbachBeteiligter beteiligter;
    private JLabel lblStreitwert;
    private JLabel lblUnterliegen;
    private ParsendUndBauend<BaumbachBeteiligter> pruefer = new BeteiligtenParser();

    public BeteiligtenHinzufuegenDialog(JFrame owner, BaumbachBeteiligter beteiligter, boolean widerKlageAnzeigen) {
        super((Window)owner, (Beschriftung)((Object)new ComponentBeschrifter().changeTo((Vorsorgend)((Object)NameContainerSammlung.BESCHRIFTUNGEN.get(35000)), beteiligter.getTyp().ordinal())));
        this.widerKlageAnzeigen = widerKlageAnzeigen;
        this.beteiligter = beteiligter;
        this.beteiligtenTyp = beteiligter.getTyp();
    }

    @Override
    public boolean parseEingabe() {
        return this.pruefer.leseComponents(this.cmbTypGenusNumerus, this.cbAnWiderklageBeteiligt, this.ftfStreitwert, this.ftfUnterliegen).parseEingabe();
    }

    Beteiligter.BeteiligtenTyp getBeteiligtenTyp() {
        return this.beteiligtenTyp;
    }

    @Override
    protected void fuelleContentPane() {
        this.cmbTypGenusNumerus = this.fillBeteiligtenCombo(this.beteiligtenTyp);
        this.togetherToContentPanel(this.cmbTypGenusNumerus, (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(35005));
        this.cbAnWiderklageBeteiligt = (JCheckBox)this.toContentPanel(new JCheckBox(), NameContainerSammlung.BESCHRIFTUNGEN.get(35011));
        this.cbAnWiderklageBeteiligt.setSelected(this.beteiligter.isAnWiderklageBeteiligt());
        this.cbAnWiderklageBeteiligt.setVisible(this.widerKlageAnzeigen);
        this.lblStreitwert = new JLabel();
        this.ftfStreitwert = (JFormattedTextField)this.toContentPanel(this.lblStreitwert, new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(35025));
        this.ftfStreitwert.setText(String.valueOf(this.beteiligter.getAntrag().doubleValue()));
        this.setEnterAction(this.ftfStreitwert, this.getOkAction());
        if (!this.widerKlageAnzeigen && this.beteiligtenTyp == Beteiligter.BeteiligtenTyp.KLAEGER) {
            this.ftfStreitwert.setText("0");
            this.lblStreitwert.setVisible(false);
            this.ftfStreitwert.setVisible(false);
        }
        this.lblUnterliegen = new JLabel();
        this.ftfUnterliegen = (JFormattedTextField)this.toContentPanel(this.lblUnterliegen, new JFormattedTextField(this.formatter), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(35035));
        this.ftfUnterliegen.setText(String.valueOf(this.beteiligter.getErfolg().doubleValue()));
        this.setEnterAction(this.ftfUnterliegen, this.getOkAction());
        if (!this.widerKlageAnzeigen && this.beteiligtenTyp == Beteiligter.BeteiligtenTyp.KLAEGER) {
            this.ftfUnterliegen.setText("0");
            this.lblUnterliegen.setVisible(false);
            this.ftfUnterliegen.setVisible(false);
        }
        WiderklageCheckboxTextfieldHorcher horcher = new WiderklageCheckboxTextfieldHorcher(this.cmbTypGenusNumerus, this.cbAnWiderklageBeteiligt, this.ftfStreitwert, this.ftfUnterliegen, (VorsorgendeBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(35011));
        this.cmbTypGenusNumerus.addItemListener(horcher);
        this.cbAnWiderklageBeteiligt.addChangeListener(horcher);
        this.cmbTypGenusNumerus.setSelectedIndex(this.beteiligter.getGenusNumerus().getGenus().ordinal());
        horcher.stateChanged(new ChangeEvent(this));
        horcher.itemStateChanged(null);
    }

    @Override
    protected BaumbachBeteiligter baueRueckgabewert() {
        return this.pruefer.leseComponents(this.cmbTypGenusNumerus, this.cbAnWiderklageBeteiligt, this.ftfStreitwert, this.ftfUnterliegen).getRueckgabewert();
    }

    private JComboBox<Beteiligter> fillBeteiligtenCombo(Beteiligter.BeteiligtenTyp beteiligtenTyp) {
        Beteiligter[] beteiligtenAuswahlListe = BaumbachBeteiligter.getBeteiligtenAuswahlListe(beteiligtenTyp, false);
        JComboBox<Beteiligter> jComboBox = new JComboBox<Beteiligter>(beteiligtenAuswahlListe);
        jComboBox.setEnabled(true);
        jComboBox.setEditable(false);
        jComboBox.setRenderer(BeteiligtenCellEditor.BETEILIGTEN_RENDERER_OHNE_LFDNR);
        return jComboBox;
    }
}

