/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.KostenListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class BeteiligtenListRenderer
extends KostenListRenderer
implements ListCellRenderer<Beteiligter> {
    private static final long serialVersionUID = -4580949588130202239L;
    private static final int FONT_MULTIPLIKATOR = 19;
    private final JLabel lbParteiBezeichner = new JLabel();
    private final JLabel lbStreitwert = new JLabel();
    private final JLabel lbUnterliegen = new JLabel();
    private final boolean laufendeNummerImmerAusblenden;

    public BeteiligtenListRenderer(boolean laufendeNummerImmerAusblenden) {
        this.helfer.boldLabel(this.lbParteiBezeichner);
        this.lbUnterliegen.setHorizontalAlignment(4);
        this.helfer.sizeLabel(this.lbStreitwert, 19);
        super.setLayout(new BorderLayout());
        super.add((Component)this.lbParteiBezeichner, "First");
        super.add((Component)this.lbStreitwert, "Center");
        super.add((Component)this.lbUnterliegen, "After");
        this.setAllOpaque(true);
        this.laufendeNummerImmerAusblenden = laufendeNummerImmerAusblenden;
    }

    public BeteiligtenListRenderer() {
        this(false);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Beteiligter> list, Beteiligter value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean einzigerSeinerArt = this.laufendeNummerImmerAusblenden ? this.laufendeNummerImmerAusblenden : list.getModel().getSize() < 2;
        this.lbParteiBezeichner.setText(value.parteiBezeichner(Beteiligter.Casus.NOMINATIV, value.getLfdNr(), einzigerSeinerArt));
        this.setSelected(isSelected);
        if (value instanceof BaumbachBeteiligter) {
            this.lbStreitwert.setText(String.format("Inanspruchnahme: %s EUR", ((BaumbachBeteiligter)value).getAntrag()));
            this.lbUnterliegen.setText(String.format("Verurteilung: %s EUR", ((BaumbachBeteiligter)value).getErfolg()));
            if (((BaumbachBeteiligter)value).isAnWiderklageBeteiligt()) {
                Beteiligter.GenusNumerus genusNumerus = value.getGenusNumerus();
                if (genusNumerus.getNumerus() == Beteiligter.GenusNumerus.Numerus.PLURAL) {
                    genusNumerus = Beteiligter.GenusNumerus.of(genusNumerus.getGenus(), Beteiligter.GenusNumerus.Numerus.SINGULAR);
                }
                switch (value.getTyp()) {
                    case KLAEGER: {
                        this.lbParteiBezeichner.setText(String.format("%s und %s", this.lbParteiBezeichner.getText(), BaumbachBeteiligter.WIDERBEKLAGTEN_BEUGUNG[genusNumerus.getGenus().ordinal()]));
                        break;
                    }
                    case BEKLAGTE: {
                        this.lbParteiBezeichner.setText(String.format("%s und %s", this.lbParteiBezeichner.getText(), BaumbachBeteiligter.WIDERKLAEGER_BEUGUNG[genusNumerus.getGenus().ordinal()]));
                        break;
                    }
                }
            }
            super.setToolTipText(this.lbParteiBezeichner.getText());
            return this;
        }
        this.lbParteiBezeichner.setToolTipText(this.lbParteiBezeichner.getText());
        this.setSelected(this.lbParteiBezeichner, isSelected);
        return this.lbParteiBezeichner;
    }
}

