/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.baumbach;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.EintragEntfernenAktion;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenAssistentAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenBaumbachAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenBeteiligterNeuAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenGesamtschuldBkExtractAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenGesamtschuldDwbkExtractAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenGesamtschuldnerBkAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenGesamtschuldnerDwbkAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenParser;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenWiderklageAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenXJustizLesenAction;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.data.baumbach.Widerklage;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenCellEditor;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenTableRenderer;
import eu.gronos.kostenrechner.view.baumbach.WiderklageTableRendererEditor;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class StreitgenossenPanel
extends KostenJPanel
implements WerteLesbar<Streitgenossen>,
StreitgenossenTabellenBehandelnd {
    private static final long serialVersionUID = 1265694381131490890L;
    private static final StreitgenossenPanel instance = new StreitgenossenPanel();
    private Kostenrechner kostenrechner;
    private boolean widerKlageAnzeigen;
    public JTable tabKlaeger;
    public BeteiligtenTableModel btmKlaeger;
    public JTable tabBeklagte;
    public BeteiligtenTableModel btmBeklagte;
    private final AbstractAction neuerKlaegerAction = new StreitgenossenBeteiligterNeuAction(this, Beteiligter.BeteiligtenTyp.KLAEGER, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(31021));
    private final AbstractAction neuerBeklagterAction = new StreitgenossenBeteiligterNeuAction(this, Beteiligter.BeteiligtenTyp.BEKLAGTE, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(32021));
    private final AbstractAction neuerDrittwiderbeklagterAction = new StreitgenossenBeteiligterNeuAction(this, Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(33121));
    public JTable tabDrittwiderbeklagte;
    public BeteiligtenTableModel btmDrittwiderbeklagte;
    private JScrollPane scpDwbk;
    private JButton btnWiderklageAnzeigen;
    private JButton btnDrittwiderbeklagterNeu;
    private JButton btnKlDwblGesamtsch;
    private AbstractAction bkGesamtschuldnerAction = new StreitgenossenGesamtschuldnerBkAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(32031));
    private final AbstractAction widerKlageAktivierenAction = new StreitgenossenWiderklageAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(33001));
    private final AbstractAction klDwbkGesamtschAction = new StreitgenossenGesamtschuldnerDwbkAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(33131));
    private final AbstractAction baumbachAction = new StreitgenossenBaumbachAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(34001));
    public final BeschriebeneAktion gesamtschuldnerschaftDwbkExtrahierenAction = new StreitgenossenGesamtschuldDwbkExtractAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(39111));
    public final BeschriebeneAktion gesamtschuldnerschaftExtrahierenAction = new StreitgenossenGesamtschuldBkExtractAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(39211));
    public AbstractAction xmlLesenAction = new StreitgenossenXJustizLesenAction(this, this.getKostenrechner(), (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(61031));
    public AbstractAction baumbachAssistentAction = new StreitgenossenAssistentAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(62051));
    private boolean wirtschaftlichIdentisch = false;
    public static final String FEHLER_BERECHNUNG = "Fehler bei der Berechnung! ";
    private static final String FEHLER_GESAMTSCHULD_NIX_LOESCHEN = "Eintr\u00e4ge k\u00f6nnen nicht entfernt werden, wenn bereits eine Gesamtschuldnerschaft vorhanden ist.";
    public static final String FEHLER_GESAMTSCHULDNERSCHAFT = "Fehler beim Hinzuf\u00fcgen einer Gesamtschuldnerschaft";
    public static final String FEHLER_NIX_PARTEIEN = "Fehler: Keine Kl\u00e4ger und/oder Beklagten vorhanden";
    public static final String FEHLER_NIX_PARTEIEN_LANG = "Die Berechnung erfordert einen Kl\u00e4ger und mindestens einen Beklagten.";
    private static final WiderklageTableRendererEditor WIDERKLAGE_RENDERER_EDITOR = new WiderklageTableRendererEditor();
    public static final BeteiligtenTableRenderer BETEILIGTEN_RENDERER = new BeteiligtenTableRenderer();
    private ParsendUndBauend<Streitgenossen> pruefer = new StreitgenossenParser();

    private StreitgenossenPanel() {
    }

    public static StreitgenossenPanel getInstance() {
        return instance;
    }

    @Override
    public void buildPanel() {
        this.setWiderKlageAnzeigen(false);
        this.leereWerte();
        JPanel pnKlaeger = this.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(31000), new GridBagLayout());
        this.tabKlaeger = (JTable)this.beschrifter.beschrifte(new JTable(this.btmKlaeger), NameContainerSammlung.BESCHRIFTUNGEN.get(31011));
        this.setzeBeteiligtenRenderer(this.tabKlaeger);
        this.beschrifter.beschrifteVergittert(new JScrollPane(this.tabKlaeger), NameContainerSammlung.BESCHRIFTUNGEN.get(31010), pnKlaeger);
        this.entferneTastaturFalle(this.tabKlaeger);
        this.baueEditModeEin(this.tabKlaeger);
        JPanel pnBeklagte = this.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(32000), new GridBagLayout());
        this.tabBeklagte = (JTable)this.beschrifter.beschrifte(new JTable(this.btmBeklagte), NameContainerSammlung.BESCHRIFTUNGEN.get(32011));
        this.setzeBeteiligtenRenderer(this.tabBeklagte);
        this.beschrifter.beschrifteVergittert(new JScrollPane(this.tabBeklagte), NameContainerSammlung.BESCHRIFTUNGEN.get(32010), pnBeklagte);
        this.entferneTastaturFalle(this.tabBeklagte);
        this.baueEditModeEin(this.tabBeklagte);
        this.beschrifter.add((BeschriebeneAktion)this.neuerKlaegerAction, (Container)pnKlaeger);
        JPanel pnWiderklage = this.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(33000), new GridBagLayout());
        this.tabDrittwiderbeklagte = (JTable)this.beschrifter.beschrifte(new JTable(this.btmDrittwiderbeklagte), NameContainerSammlung.BESCHRIFTUNGEN.get(33111));
        this.setzeBeteiligtenRenderer(this.tabDrittwiderbeklagte);
        this.scpDwbk = (JScrollPane)this.beschrifter.beschrifteVergittert(new JScrollPane(this.tabDrittwiderbeklagte), NameContainerSammlung.BESCHRIFTUNGEN.get(33110), pnWiderklage);
        this.entferneTastaturFalle(this.tabDrittwiderbeklagte);
        this.baueEditModeEin(this.tabDrittwiderbeklagte);
        this.btnDrittwiderbeklagterNeu = (JButton)this.beschrifter.add((BeschriebeneAktion)this.neuerDrittwiderbeklagterAction, (Container)pnWiderklage);
        this.beschrifter.add((BeschriebeneAktion)this.neuerBeklagterAction, (Container)pnBeklagte);
        this.btnKlDwblGesamtsch = (JButton)this.beschrifter.add((BeschriebeneAktion)this.klDwbkGesamtschAction, (Container)pnWiderklage);
        this.btnWiderklageAnzeigen = (JButton)this.beschrifter.add((BeschriebeneAktion)this.widerKlageAktivierenAction, (Container)pnWiderklage);
        this.beschrifter.add((BeschriebeneAktion)this.bkGesamtschuldnerAction, (Container)pnBeklagte);
        this.beschrifter.add((BeschriebeneAktion)this.baumbachAction, (Container)this);
        this.setWiderKlageAnzeigen(false);
        PopupMenuBuilder builder = new PopupMenuBuilder();
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(39100), this.tabKlaeger, new Integer[]{1}, (BeschriebeneAktion)this.neuerKlaegerAction, (BeschriebeneAktion)this.klDwbkGesamtschAction, this.gesamtschuldnerschaftDwbkExtrahierenAction, (BeschriebeneAktion)this.eintragEntfernenAktion);
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(39200), this.tabBeklagte, new Integer[]{1}, (BeschriebeneAktion)this.neuerBeklagterAction, (BeschriebeneAktion)this.bkGesamtschuldnerAction, this.gesamtschuldnerschaftExtrahierenAction, (BeschriebeneAktion)this.eintragEntfernenAktion);
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(39300), this.tabDrittwiderbeklagte, new Integer[]{1}, (BeschriebeneAktion)this.neuerDrittwiderbeklagterAction, (BeschriebeneAktion)this.klDwbkGesamtschAction, this.gesamtschuldnerschaftDwbkExtrahierenAction, (BeschriebeneAktion)this.eintragEntfernenAktion);
        this.logDauer();
    }

    @Override
    public void setzeWerte(Streitgenossen container) {
        this.setWiderKlageAnzeigen(container.widerklage);
        this.setWirtschaftlichIdentisch(container.wirtschaftlichIdentisch);
        this.btmKlaeger = new BeteiligtenTableModel(Beteiligter.BeteiligtenTyp.KLAEGER, this.isWiderKlageAnzeigen(), container.klaeger);
        this.tabKlaeger.setModel(this.btmKlaeger);
        this.btmDrittwiderbeklagte = new BeteiligtenTableModel(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE, this.isWiderKlageAnzeigen(), container.drittwiderbeklagte);
        this.tabDrittwiderbeklagte.setModel(this.btmDrittwiderbeklagte);
        this.btmBeklagte = new BeteiligtenTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE, this.isWiderKlageAnzeigen(), container.beklagte);
        this.tabBeklagte.setModel(this.btmBeklagte);
        Kostenrechner.getLogger().info("Fertig!");
    }

    @Override
    public Streitgenossen baueRueckgabewert() {
        ((StreitgenossenParser)this.pruefer).setzeSonstigeWerte(new Widerklage(this.isWiderKlageAnzeigen(), this.isWirtschaftlichIdentisch())).leseComponents(this.tabKlaeger, this.tabBeklagte, this.tabDrittwiderbeklagte).parseEingabe();
        return this.pruefer.getRueckgabewert();
    }

    @Override
    public void setWiderKlageAnzeigen(boolean widerKlageAnzeigen) {
        this.widerKlageAnzeigen = widerKlageAnzeigen;
        if (this.scpDwbk != null) {
            this.scpDwbk.setVisible(widerKlageAnzeigen);
        }
        if (this.btnDrittwiderbeklagterNeu != null) {
            this.btnDrittwiderbeklagterNeu.setVisible(widerKlageAnzeigen);
        }
        if (this.btnKlDwblGesamtsch != null) {
            this.btnKlDwblGesamtsch.setVisible(widerKlageAnzeigen);
        }
        if (this.btnWiderklageAnzeigen != null) {
            this.btnWiderklageAnzeigen.setVisible(!widerKlageAnzeigen);
        }
    }

    @Override
    public void leereWerte() {
        this.btmKlaeger = new BeteiligtenTableModel(Beteiligter.BeteiligtenTyp.KLAEGER, this.isWiderKlageAnzeigen(), new BaumbachBeteiligtenListe());
        this.btmDrittwiderbeklagte = new BeteiligtenTableModel(Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE, this.isWiderKlageAnzeigen());
        this.btmBeklagte = new BeteiligtenTableModel(Beteiligter.BeteiligtenTyp.BEKLAGTE, this.isWiderKlageAnzeigen(), new BaumbachBeteiligtenListe());
        if (this.tabKlaeger != null) {
            this.tabKlaeger.setModel(this.btmKlaeger);
        }
        if (this.tabBeklagte != null) {
            this.tabBeklagte.setModel(this.btmBeklagte);
        }
        if (this.tabDrittwiderbeklagte != null) {
            this.tabDrittwiderbeklagte.setModel(this.btmDrittwiderbeklagte);
        }
    }

    private void setzeBeteiligtenRenderer(JTable table) {
        table.setDefaultRenderer(Beteiligter.class, BETEILIGTEN_RENDERER);
        table.setDefaultEditor(Beteiligter.class, new BeteiligtenCellEditor(((BeteiligtenTableModel)table.getModel()).getBeteiligtenTyp()));
        table.setDefaultRenderer(Double.class, EURO_RENDERER);
        table.setDefaultRenderer(Euro.class, EURO_RENDERER);
        table.setDefaultEditor(Double.class, EURO_EDITOR);
        table.setDefaultEditor(Euro.class, EURO_EDITOR);
        table.setDefaultRenderer(Boolean.class, WIDERKLAGE_RENDERER_EDITOR);
        table.setDefaultEditor(Boolean.class, WIDERKLAGE_RENDERER_EDITOR);
        table.setSelectionMode(0);
        table.getTableHeader().setDefaultRenderer(HEADER_RENDERER);
    }

    @Override
    public boolean pruefeTabellen() {
        return this.btmKlaeger.getRowCount() > 0 && this.btmBeklagte.getRowCount() > 0;
    }

    @Override
    public void setKostenrechner(Kostenrechner kostenrechner) {
        this.kostenrechner = kostenrechner;
    }

    public void entferneBeteiligtenEintrag(JTable table, BeteiligtenTableModel model) {
        if (model == null) {
            return;
        }
        if (model.getAllValues() != null && model.getAllValues().enthaeltGesamtschuldner()) {
            if (table.getSelectedRow() > -1 && !model.getRow(table.getSelectedRow()).isGesamtschuldnerschaft()) {
                FehlerHelper.zeigeFehler(FEHLER_GESAMTSCHULD_NIX_LOESCHEN, new IllegalArgumentException(FEHLER_GESAMTSCHULD_NIX_LOESCHEN));
                return;
            }
        } else if (model.getBeteiligtenTyp() == Beteiligter.BeteiligtenTyp.KLAEGER && this.btmDrittwiderbeklagte.getAllValues() != null && this.btmDrittwiderbeklagte.getAllValues().enthaeltGesamtschuldner() && table.getSelectedRow() > -1 && !model.getRow(table.getSelectedRow()).isGesamtschuldnerschaft()) {
            FehlerHelper.zeigeFehler(FEHLER_GESAMTSCHULD_NIX_LOESCHEN, new IllegalArgumentException(FEHLER_GESAMTSCHULD_NIX_LOESCHEN));
            return;
        }
        ((EintragEntfernenAktion)this.eintragEntfernenAktion).entferneTabellenEintrag(table, model);
    }

    @Override
    public Kostenrechner getKostenrechner() {
        return this.kostenrechner;
    }

    @Override
    public boolean isWirtschaftlichIdentisch() {
        return this.wirtschaftlichIdentisch;
    }

    @Override
    public void setWirtschaftlichIdentisch(boolean wirtschaftlichIdentisch) {
        this.wirtschaftlichIdentisch = wirtschaftlichIdentisch;
    }

    @Override
    public boolean isWiderKlageAnzeigen() {
        return this.widerKlageAnzeigen;
    }

    @Override
    public BeteiligtenTableModel getTableModel(int index) {
        Beteiligter.BeteiligtenTyp typ = index < 0 || index >= Beteiligter.BeteiligtenTyp.values().length ? null : Beteiligter.BeteiligtenTyp.of(index);
        switch (typ) {
            case KLAEGER: {
                return this.btmKlaeger;
            }
            case DRITTWIDERBEKLAGTE: {
                return this.btmDrittwiderbeklagte;
            }
            case BEKLAGTE: {
                return this.btmBeklagte;
            }
        }
        return null;
    }

    @Override
    public boolean requestFocusInWindow() {
        this.getKostenrechner().getTabbedPane().setSelectedIndex(1);
        return super.requestFocusInWindow();
    }

    @Override
    public BeschriebeneAktion getExtrahierenAktion(Beteiligter.BeteiligtenTyp beteiligtenTyp) throws IllegalArgumentException {
        if (Beteiligter.BeteiligtenTyp.BEKLAGTE == beteiligtenTyp) {
            return this.gesamtschuldnerschaftExtrahierenAction;
        }
        if (Beteiligter.BeteiligtenTyp.DRITTWIDERBEKLAGTE == beteiligtenTyp) {
            return this.gesamtschuldnerschaftDwbkExtrahierenAction;
        }
        throw new IllegalArgumentException(String.format("Unbekannter Beteiligtentyp: %d", new Object[]{beteiligtenTyp}));
    }
}

