/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.gebuehren;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.beschriftungen.model.NameContainerSammlung;
import eu.gronos.beschriftungen.model.UnBeschriftung;
import eu.gronos.beschriftungen.view.PopupMenuBuilder;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.AllzweckHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrNeuAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenAufstellungAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenBerechnungAufrufHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenBerechnungParser;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenSetzeRechnerTabelleAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenStreitwertHorcher;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenTabelleDruckenAction;
import eu.gronos.kostenrechner.controller.gebuehren.GebuehrenTabelleKopierenAction;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAuflistung;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.interfaces.WerteLesbar;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.model.gebuehren.StreitwertTableModel;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJPanel;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;

public class GebuehrenBerechnungPanel
extends KostenJPanel
implements WerteLesbar<GebuehrenBerechnung>,
GebuehrenTableTextfieldHandler {
    private static final String SUMME_EUR = "Summe: %,.2f EUR";
    private static final long serialVersionUID = -8251865293845494552L;
    private static final GebuehrenBerechnungPanel instance = new GebuehrenBerechnungPanel();
    private Kostenrechner kostenrechner;
    private JTable tabStreitwertTabelle;
    private JFormattedTextField ftfStreitwert;
    public JTable tabGebuehrenTatbestaende;
    private JTextField tfGebuehrenSumme;
    public GebuehrenTableModel gttmRechner;
    private final AbstractAction neueGkgGebuehrAction = new GebuehrNeuAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(22021), 8, 64);
    private final AbstractAction neueRvgVerguetungAction = new GebuehrNeuAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(22031), 8, 32);
    private final AbstractAction gebuehrenAufstellungAction = new GebuehrenAufstellungAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(23031));
    public final AbstractAction normaleGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24221), 103);
    public final AbstractAction saeumnisGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24211), 102);
    public final AbstractAction anerkenntnisGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24215), 101);
    private final AbstractAction mitInstanzGebuehrenAction = new GebuehrenSetzeRechnerTabelleAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24225), 104);
    private final AbstractAction druckeSwTabelleAction = new GebuehrenTabelleDruckenAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24111));
    private final AbstractAction kopiereSwTabelleAction = new GebuehrenTabelleKopierenAction(this, (LangBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24101));
    private final AllzweckHorcher aktualisierungsHorcher = new GebuehrenStreitwertHorcher(this, ((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(21001)).getTitle());
    public static final String FEHLER_DRUCKEN = "Fehler beim Drucken";
    public static final int FTF_STREITWERT = 5;
    public static final int TABLE_GEBUEHREN = 8;
    private JLabel lblStreitwert;
    private ParsendUndBauend<GebuehrenBerechnung> pruefer = new GebuehrenBerechnungParser();
    private GebuehrenBerechnungAufrufHorcher aufrufHorcher;

    private GebuehrenBerechnungPanel() {
    }

    public static GebuehrenBerechnungPanel getInstance() {
        return instance;
    }

    @Override
    public void buildPanel() {
        JPanel pnStreitwert = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(21000), new GridBagLayout());
        this.lblStreitwert = new JLabel();
        this.setFormattedTextField(5, (JFormattedTextField)this.beschrifter.beschrifteGemeinsam(this.lblStreitwert, new JFormattedTextField(KostenJPanel.FORMATTER), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(21005), pnStreitwert));
        this.getFormattedTextField(5).setColumns(10);
        this.getFormattedTextField(5).setText("0");
        this.getFormattedTextField(5).addFocusListener(HinzufuegenDialog.BEI_FOCUS_MARKIEREN);
        this.setTabStreitwertTabelle((JTable)this.beschrifter.beschrifte(new JTable(), NameContainerSammlung.BESCHRIFTUNGEN.get(21021)));
        this.setAufrufHorcher(new GebuehrenBerechnungAufrufHorcher());
        this.getTabStreitwertTabelle().setDefaultRenderer(Long.class, KostenJPanel.EURO_RENDERER);
        this.getTabStreitwertTabelle().setDefaultRenderer(Double.class, KostenJPanel.EURO_RENDERER);
        this.getTabStreitwertTabelle().getTableHeader().setDefaultRenderer(KostenJPanel.HEADER_RENDERER);
        this.getTabStreitwertTabelle().setSelectionMode(0);
        this.entferneTastaturFalle(this.getTabStreitwertTabelle());
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.getTabStreitwertTabelle()), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(21020), pnStreitwert);
        this.getFormattedTextField(5).addFocusListener(this.aktualisierungsHorcher);
        this.getFormattedTextField(5).addKeyListener(this.aktualisierungsHorcher);
        this.getTabStreitwertTabelle().addFocusListener(this.aktualisierungsHorcher);
        this.getTabStreitwertTabelle().addMouseListener(this.aktualisierungsHorcher);
        this.getTabStreitwertTabelle().addKeyListener(this.aktualisierungsHorcher);
        this.getTabStreitwertTabelle().getSelectionModel().addListSelectionListener(this.aktualisierungsHorcher);
        JPanel pnGebuehren = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(22000), new GridBagLayout());
        this.tabGebuehrenTatbestaende = (JTable)this.beschrifter.beschrifte(new JTable(), NameContainerSammlung.BESCHRIFTUNGEN.get(22011));
        this.leereGebuehrenTabellen();
        this.entferneTastaturFalle(this.tabGebuehrenTatbestaende);
        this.setzeGebuehrenTabelleAussehen(this.tabGebuehrenTatbestaende);
        this.beschrifter.beschrifteGemeinsam(new JScrollPane(this.tabGebuehrenTatbestaende), (UnBeschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(22010), pnGebuehren);
        this.beschrifter.add((BeschriebeneAktion)this.neueRvgVerguetungAction, (Container)pnGebuehren);
        this.beschrifter.add((BeschriebeneAktion)this.neueGkgGebuehrAction, (Container)pnGebuehren);
        JPanel pnAufstellung = super.addNewPanel((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(23000), new GridBagLayout());
        this.tfGebuehrenSumme = (JTextField)this.beschrifter.beschrifteVergittert(new JTextField(), NameContainerSammlung.BESCHRIFTUNGEN.get(23005), pnAufstellung);
        this.tfGebuehrenSumme.setEditable(false);
        this.beschrifter.add((BeschriebeneAktion)this.gebuehrenAufstellungAction, (Container)pnAufstellung);
        this.errechneGebuehrenSumme();
        PopupMenuBuilder builder = new PopupMenuBuilder();
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24100), this.getTabStreitwertTabelle(), new Integer[]{1}, (BeschriebeneAktion)this.druckeSwTabelleAction, (BeschriebeneAktion)this.kopiereSwTabelleAction);
        builder.build((Beschriftung)NameContainerSammlung.BESCHRIFTUNGEN.get(24200), this.tabGebuehrenTatbestaende, new Integer[]{1}, (BeschriebeneAktion)this.neueGkgGebuehrAction, (BeschriebeneAktion)this.neueRvgVerguetungAction, (BeschriebeneAktion)this.saeumnisGebuehrenAction, (BeschriebeneAktion)this.anerkenntnisGebuehrenAction, (BeschriebeneAktion)this.normaleGebuehrenAction, (BeschriebeneAktion)this.mitInstanzGebuehrenAction, (BeschriebeneAktion)this.eintragEntfernenAktion);
        this.logDauer();
    }

    @Override
    public void leereWerte() {
        this.leereGebuehrenTabellen();
    }

    @Override
    public void setzeWerte(GebuehrenBerechnung container) {
        this.getFormattedTextField(5).setText(container.streitwert.toString());
        this.aktualisierungsHorcher.focusLost(new FocusEvent(this.getFormattedTextField(5), 1005));
        if (this.gttmRechner == null) {
            this.gttmRechner = new GebuehrenTableModel(container.gebuehren);
            this.gttmRechner.addTableModelListener(this.aktualisierungsHorcher);
            this.tabGebuehrenTatbestaende.setModel(this.gttmRechner);
        } else {
            this.gttmRechner.clear();
            this.gttmRechner.addAll(container.gebuehren);
        }
    }

    @Override
    public void setKostenrechner(Kostenrechner kostenrechner) {
        this.kostenrechner = kostenrechner;
    }

    public void errechneGebuehrenSumme() {
        String streitwert = "";
        Euro gebuehrenSumme = Euro.ofCents(0L);
        if (this.getFormattedTextField(5) != null && this.pruefeTabellen()) {
            try {
                streitwert = this.getFormattedTextField(5).getText();
                gebuehrenSumme = this.gttmRechner.getValues().errechneGebuehrenSummeMitSteuer(Euro.ofEuros(this.longAusFormatter(this.getFormattedTextField(5), this.getLabelText(5))));
            }
            catch (NumberFormatException e) {
                FehlerHelper.zeigeFehler("Falsches Eingabeformat f\u00fcr den Streitwert: \"" + streitwert + "\"!\n ", e);
            }
        }
        String text = String.format(SUMME_EUR, gebuehrenSumme.doubleValue());
        if (this.tfGebuehrenSumme != null) {
            this.tfGebuehrenSumme.setText(text);
        }
    }

    @Override
    public GebuehrenBerechnung baueRueckgabewert() throws NumberFormatException, NullPointerException {
        this.pruefer.leseComponents(this.getFormattedTextField(5), this.tabGebuehrenTatbestaende).parseEingabe();
        return this.pruefer.getRueckgabewert();
    }

    @Override
    public boolean pruefeTabellen() {
        return this.getTableModel(8) != null && this.getTableModel(8).getRowCount() > 0;
    }

    public JTable getTabStreitwertTabelle() {
        return this.tabStreitwertTabelle;
    }

    public void setTabStreitwertTabelle(JTable tabStreitwertTabelle) {
        this.tabStreitwertTabelle = tabStreitwertTabelle;
    }

    @Override
    public JFormattedTextField getFormattedTextField(int index) {
        return this.ftfStreitwert;
    }

    @Override
    public String getLabelText(int index) {
        if (this.lblStreitwert != null) {
            return this.lblStreitwert.getText();
        }
        return "";
    }

    public Kostenrechner getKostenrechner() {
        return this.kostenrechner;
    }

    @Override
    public GebuehrenTableModel getTableModel(int index) {
        if (index != 8 && Kostenrechner.debug) {
            IllegalArgumentException ie = new IllegalArgumentException(String.format("Fehler: index war nicht TABLE_GEBUEHREN, sondern: '%d'!", index));
            FehlerHelper.zeigeFehler(ie.getLocalizedMessage(), ie);
        }
        return this.gttmRechner;
    }

    @Override
    public int getSelectedRow(int index) throws IndexOutOfBoundsException {
        if (index != 8 && Kostenrechner.debug) {
            IllegalArgumentException ie = new IllegalArgumentException(String.format("Fehler: index war nicht TABLE_GEBUEHREN, sondern: '%d'!", index));
            FehlerHelper.zeigeFehler(ie.getLocalizedMessage(), ie);
        }
        if (this.tabGebuehrenTatbestaende != null) {
            return this.tabGebuehrenTatbestaende.getSelectedRow();
        }
        return -1;
    }

    @Override
    public boolean requestFocusInWindow() {
        this.getKostenrechner().getTabbedPane().setSelectedComponent(this);
        return super.requestFocusInWindow();
    }

    public GebuehrenBerechnungAufrufHorcher getAufrufHorcher() {
        return this.aufrufHorcher;
    }

    public void initStreitwertTable() {
        this.getTabStreitwertTabelle().setModel(new StreitwertTableModel());
        this.getTabStreitwertTabelle().tableChanged(new TableModelEvent(this.getTabStreitwertTabelle().getModel()));
    }

    private void leereGebuehrenTabellen() {
        GebuehrenAuflistung values = new GebuehrenAuflistung();
        if (this.gttmRechner == null) {
            this.gttmRechner = new GebuehrenTableModel(values);
            this.gttmRechner.addTableModelListener(this.aktualisierungsHorcher);
            this.tabGebuehrenTatbestaende.setModel(this.gttmRechner);
        } else {
            this.gttmRechner.clear();
            this.gttmRechner.addAll(values);
        }
    }

    private void setFormattedTextField(int index, JFormattedTextField ftfStreitwert) {
        this.ftfStreitwert = ftfStreitwert;
    }

    private void setAufrufHorcher(GebuehrenBerechnungAufrufHorcher aufrufHorcher) {
        this.aufrufHorcher = aufrufHorcher;
    }
}

