/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AnwaltsGebuehrenTabelle;
import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenErhoehungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRahmenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrfachPauschalTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrwertsteuerTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.data.tenordaten.Euro;
import eu.gronos.kostenrechner.view.KostenListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class GebuehrenListRenderer
extends KostenListRenderer
implements ListCellRenderer<GebuehrenTatbestand> {
    private static final long serialVersionUID = 511158574706627353L;
    private static final int FONT_MULTIPLIKATOR = 21;
    private final JLabel lbBezeichnung = new JLabel();
    private final JLabel lbGesetz = new JLabel();
    private final JLabel lbSatz = new JLabel();
    private final JLabel lbArt = new JLabel();

    public GebuehrenListRenderer() {
        this.helfer.boldLabel(this.lbBezeichnung);
        this.lbSatz.setHorizontalAlignment(4);
        this.helfer.sizeLabel(this.lbGesetz, 21);
        super.setLayout(new BorderLayout());
        super.add((Component)this.lbBezeichnung, "First");
        super.add((Component)this.lbGesetz, "Before");
        super.add((Component)this.lbArt, "Center");
        super.add((Component)this.lbSatz, "After");
        this.setAllOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends GebuehrenTatbestand> list, GebuehrenTatbestand value, int index, boolean isSelected, boolean cellHasFocus) {
        this.lbBezeichnung.setText(value.getBezeichnung());
        if (AnwaltsGebuehrenTabelle.class.equals(value.getGebuehrenKlasse())) {
            this.lbGesetz.setText(String.format("%s RVG", value.getVorschrift()));
        } else {
            this.lbGesetz.setText(String.format("%s GKG", value.getVorschrift()));
        }
        if (value instanceof GebuehrenAnrechnungsTatbestand) {
            GebuehrenAnrechnungsTatbestand gat = (GebuehrenAnrechnungsTatbestand)value;
            this.lbArt.setText("Anrechnungstatbestand");
            this.lbSatz.setText(String.format("%,.2f-fach (%,.2f-%,.2f-fach)", gat.getSatz(), gat.getUntergrenze(), gat.getObergrenze()));
        } else if (value instanceof GebuehrenRahmenTatbestand) {
            GebuehrenRahmenTatbestand grt = (GebuehrenRahmenTatbestand)value;
            this.lbArt.setText("Geb\u00fchrenrahmen");
            this.lbSatz.setText(String.format("%,.1f-fach (%,.1f-%,.1f-fach)", grt.getSatz(), grt.getUntergrenze(), grt.getObergrenze()));
        } else if (value instanceof GebuehrenErhoehungsTatbestand) {
            GebuehrenErhoehungsTatbestand getb = (GebuehrenErhoehungsTatbestand)value;
            this.lbArt.setText("Mehrvertretungsgeb\u00fchr");
            this.lbSatz.setText(String.format("%,.1f-fach je %s (max. %,.1f-fach)", getb.getJeweils(), getb.getEinheit(), getb.getMaxSatz()));
        } else if (value instanceof GebuehrenSatzTatbestand) {
            GebuehrenSatzTatbestand gst = (GebuehrenSatzTatbestand)value;
            this.lbArt.setText("Geb\u00fchrensatz");
            this.lbSatz.setText(String.format("%,.1f-fach", gst.getSatz()));
        } else if (value instanceof MehrfachPauschalTatbestand) {
            MehrfachPauschalTatbestand mptb = (MehrfachPauschalTatbestand)value;
            this.lbArt.setText("mehrfache Pauschale");
            this.lbSatz.setText(String.format("%s EUR je %s", mptb.getJeweils(), mptb.getEinheit()));
        } else if (value instanceof AuslagenTatbestand) {
            AuslagenTatbestand atb = (AuslagenTatbestand)value;
            this.lbArt.setText("Auslagen");
            if (atb.getBetrag() == null || atb.getBetrag().compareTo(Euro.ofCents(0L)) < 0) {
                this.lbSatz.setText("H\u00f6he variabel");
            } else {
                this.lbSatz.setText(String.format("%s EUR", atb.getBetrag()));
            }
        } else if (value instanceof PauschalTatbestand) {
            PauschalTatbestand ptb = (PauschalTatbestand)value;
            this.lbArt.setText("Pauschale");
            this.lbSatz.setText(String.format("%s EUR", ptb.getBetrag()));
        } else if (value instanceof MehrwertsteuerTatbestand) {
            MehrwertsteuerTatbestand mwst = (MehrwertsteuerTatbestand)value;
            this.lbArt.setText("Umsatzsteuer");
            this.lbSatz.setText(String.format("%,.1f %%", 100.0 * mwst.getSteuerSatz()));
        } else {
            this.lbArt.setText("Sonstige");
            this.lbSatz.setText("");
        }
        super.setToolTipText(value.langBezeichnung());
        this.setSelected(isSelected);
        return this;
    }
}

