/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.gebuehren;

import eu.gronos.kostenrechner.data.gebuehren.AuslagenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenAnrechnungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenErhoehungsTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenRahmenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenSatzTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrfachPauschalTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.MehrwertsteuerTatbestand;
import eu.gronos.kostenrechner.data.gebuehren.PauschalTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.KostenTableRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class GebuehrenTableRenderer
extends KostenTableRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = -204281833673733183L;

    public GebuehrenTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table.getModel() instanceof GebuehrenTableModel) {
            GebuehrenTableModel gttm = (GebuehrenTableModel)table.getModel();
            GebuehrenTatbestand tb = (GebuehrenTatbestand)gttm.getAllValues().get(row);
            if (tb instanceof MehrfachPauschalTatbestand) {
                MehrfachPauschalTatbestand mptb = (MehrfachPauschalTatbestand)tb;
                this.setText(String.format("%s EUR (%d %s)", value, mptb.getAnzahl(), mptb.getEinheit()));
            } else if (tb instanceof AuslagenTatbestand) {
                AuslagenTatbestand atb = (AuslagenTatbestand)tb;
                this.setText(String.format("%s EUR", atb.getBetrag()));
            } else if (tb instanceof PauschalTatbestand) {
                PauschalTatbestand ptb = (PauschalTatbestand)tb;
                this.setText(String.format("%s EUR", ptb.getBetrag()));
            } else if (tb instanceof GebuehrenErhoehungsTatbestand) {
                GebuehrenErhoehungsTatbestand getb = (GebuehrenErhoehungsTatbestand)tb;
                this.setText(String.format("%,.2f-fach (%d %s)", value, getb.getAnzahl(), getb.getEinheit()));
            } else if (tb instanceof GebuehrenRahmenTatbestand) {
                GebuehrenRahmenTatbestand grtb = (GebuehrenRahmenTatbestand)tb;
                this.setText(String.format("%,.2f-fach (%,.2f\u2013%,.2f-f.) ", grtb.getSatz(), grtb.getUntergrenze(), grtb.getObergrenze()));
            } else if (tb instanceof GebuehrenAnrechnungsTatbestand) {
                this.setText(String.format("%,.2f-fach", value));
            } else if (tb instanceof GebuehrenSatzTatbestand) {
                this.setText(String.format("%,.1f-fach", value));
            } else if (tb instanceof MehrwertsteuerTatbestand) {
                if (value == null) {
                    System.err.printf("value == null bei: (%d, %d): %s", row, column, tb.toString());
                } else {
                    this.setText(String.format("%,.1f%%", (Double)value * 100.0));
                }
            }
            this.setHorizontalAlignment(4);
        } else {
            this.setText(Double.toString((Double)value));
        }
        this.setSelected(isSelected);
        return this;
    }
}

