/*
 * Decompiled with CFR 0.152.
 */
package eu.gronos.kostenrechner.view.gebuehren;

import eu.gronos.kostenrechner.interfaces.TooltipLieferant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class TooltipHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 9155034513233553302L;

    public TooltipHeaderRenderer() {
        super.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.getModel() instanceof TooltipLieferant) {
            TooltipLieferant lieferant = (TooltipLieferant)((Object)table.getModel());
            component.setToolTipText(lieferant.getTooltipText(column));
        } else {
            this.setToolTipText(this.getText());
        }
        this.setFontBold(component);
        this.setComponentBorder(component);
        return component;
    }

    private void setComponentBorder(JComponent component) {
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK);
        component.setBorder(border);
    }

    private void setFontBold(JComponent component) {
        Font font = component.getFont();
        font = new Font(font.getName(), 1, font.getSize());
        component.setFont(font);
    }
}

