/*
 * HinzufuegenFocusHorcher.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.beschriftungen.controller;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 * Ein {@link FocusAdapter} für {@link JTextField} und davon abgeleitete
 * markiert bei Focuserlangung den gesamten Inhalt.
 * 
 * {@link JFormattedTextField} muss immer, wenn es den Fokus bekommt, seinen
 * Inhalt komplett markieren, damit er komplett überschrieben wird.
 * 
 * @url "http://www.java-forum.org/awt-swing-javafx-and-swt/20553-jtextfield-kompletten-text-selektion-markieren.html"
 *
 * 
 * @author Peter Schuster (setrok)
 * @date 5 Mar 2019
 *
 */
public class BeiFocusMarkierenHorcher extends FocusAdapter {
	/**
	 * Markiert bei Focuserlangung den gesamten Inhalt
	 * 
	 * @param fe ein FocusEvent
	 * 
	 * @see java.awt.event.FocusAdapter#focusGained(java.awt.event.FocusEvent)
	 */
	@Override
	public void focusGained(FocusEvent fe) {
		Object o = fe.getSource();
		if (o instanceof JFormattedTextField || o instanceof JTextField) {
			selectAll((JTextField) o);
		}
	}

	@Override
	public void focusLost(FocusEvent fe) {
		Object o = fe.getSource();
		if (o instanceof JFormattedTextField || o instanceof JTextField) {
			selectAll((JTextField) o);
		}
	}

	private void selectAll(final JTextField tf) {
		/* Muss eigener Runnable sein, sonst funktioniert das nicht. */
		SwingUtilities.invokeLater(tf::selectAll);
//				new Runnable() {
//			@Override
//			public void run() {
//				tf.selectAll();
//			}
//		}
	}
}