/*
 * ConfigOption.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.beschriftungen.interfaces;

import eu.gronos.beschriftungen.model.ConfigSchluessel;

/**
 * Interface für für den Zugriff auf Registry oder Benutzereinstellungen. Die
 * Werte können als {@link ConfigSchluessel} übergeben werden.
 *
 * @author Peter Schuster (setrok)
 * @date 30.03.2020
 *
 * @param <E> der Typ des Wertes für den Eintrag in der Registry bzw. den
 *            Preferences, kann bisher {@link String}, {@link Boolean} oder
 *            {@link Integer} sein.
 */
public interface ConfigOption<E> {

	/**
	 * Die Methode soll den Schlüssel für den Eintrag als {@link String}
	 * zurückgeben.
	 * 
	 * @return gibt {@link #schluessel} als String zurück.
	 */
	public String getSchluessel();

	/**
	 * Die Methode soll den Standard-Wert für den Eintrag im Typ der Implementierung
	 * zurückliefern.
	 * 
	 * @return gibt {@link #standardWert} als <code>E</code> zurück.
	 */
	public E getStandardWert();

	/**
	 * Die Methode schreibt den Wert in die Registry/Preferences und setzt das
	 * Oberflächenelement entsprechend
	 * 
	 * @param value als <code>E</code>
	 */
	public void setValue(E value);

	/**
	 * 
	 * Die Methode liest den Wert aus der Registry (den Preferences) und setzt das
	 * Oberflächenelement entsprechend
	 * 
	 * @return value als <code>E</code>
	 */
	public E getValue();

	/**
	 * Die Methode setzt wieder den Standardwert in die Registry/Preferences.
	 */
	public void reset();

}