/*
 * Vorsorgend.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.interfaces;

import java.util.List;

import javax.swing.Action;
import javax.swing.JComponent;

import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangVorsorgeBeschriftung;
import eu.gronos.beschriftungen.model.VorsorgendeBeschriftung;

/**
 * Interface für die gemeinsamen Methoden von {@link VorsorgendeBeschriftung}
 * und {@link LangVorsorgeBeschriftung}
 *
 * @author Peter Schuster (setrok)
 * @date 05.10.2019
 *
 * @param E die von {@link Beschriftung} abgeleitete Klasse, die das Interface
 *          implementiert, also {@link VorsorgendeBeschriftung} oder
 *          {@link LangVorsorgeBeschriftung}
 */
public interface Vorsorgend<E extends Beschriftung> {

	/**
	 * @return gibt {@link #alternativeTitles} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer {@link Beschriftung#getTitle()s, die
	 *         die {@link JComponent} bzw {@link Action} in anderen Zuständen tragen
	 *         kann.
	 */
	public List<String> getAlternativeTitles();

	/**
	 * @param alternativeTitles d. {@link #alternativeTitles}, d. gesetzt werden
	 *                          soll als {@link List}&lt;{@link String}&gt;.
	 */
	public void setAlternativeTitles(List<String> alternativeTitles);

	/**
	 * @return gibt {@link #alternativeDescriptions} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Beschreibungen, die die {@link Action}
	 *         in anderen Zuständen tragen kann.
	 */
	public List<String> getAlternativeDescriptions();

	/**
	 * @param alternativeDescriptions d. {@link #getAlternativeDescriptions}, d.
	 *                                gesetzt werden soll als
	 *                                {@link List}&lt;{@link String}&gt;.
	 */
	public void setAlternativeDescriptions(List<String> alternativeDescriptions);

	/**
	 * @return gibt als {@link boolean} zurück, also ob die
	 *         {@link #getAlternativeTitles()} den {@link Beschriftung#getTitle()}
	 *         mit {@link String#format(String, Object...)} bilden sollen.
	 */
	public boolean isFormatted();
	
	/**
	 * @param formatted d. {@link #formatted}, d. gesetzt werden soll als
	 *                  {@link boolean}.
	 */
	public void setFormatted(boolean formatted);
}