package eu.gronos.beschriftungen.model;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import javax.swing.SwingConstants;
import java.util.HashMap;
import java.util.Map;

public class AlignmentAdapter extends XmlAdapter<String, Integer> {

	private static final Map<String, Integer> map = new HashMap<>();
	private static final Map<Integer, String> reverse = new HashMap<>();

	static {
		// Horizontale Ausrichtung
		map.put("LEFT", SwingConstants.LEFT);
		map.put("CENTER", SwingConstants.CENTER);
		map.put("RIGHT", SwingConstants.RIGHT);
		map.put("LEADING", SwingConstants.LEADING);
		map.put("TRAILING", SwingConstants.TRAILING);

		// Vertikale Ausrichtung
		map.put("TOP", SwingConstants.TOP);
		map.put("BOTTOM", SwingConstants.BOTTOM);

		// Rückwärtsabbildung
		for (Map.Entry<String, Integer> e : map.entrySet()) {
			reverse.put(e.getValue(), e.getKey());
		}
	}

	@Override
	public Integer unmarshal(String v) {
		if (v == null)
			return null;// SwingConstants.CENTER;
		return map.getOrDefault(v.toUpperCase(), SwingConstants.CENTER);
	}

	@Override
	public String marshal(Integer v) {
		if (v == null)
			return null;// "CENTER";
		return reverse.getOrDefault(v, "CENTER");
	}
}
