/*
 * Beschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import java.awt.event.KeyEvent;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * Eigentliche Grundklasse „Beschriftung“ mit weiterem Feldern String title
 * (XmlAttribute) und String shortDescription (XmlElement),
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class Beschriftung extends NameContainer {
	private static final long serialVersionUID = -4248042144432161109L;
	private String title;
	private String shortDescription;
	private Integer mnemonic = 0;// int


	/**
	 * The key used for storing the <code>String</code> name for the action, used
	 * for a menu or button.
	 * 
	 * @return gibt {@link #title} als {@link String} zurück.
	 */
	@XmlAttribute
	public String getTitle() {
		return title;
	}

	/**
	 * @param title d. {@link #getTitle()}, d. gesetzt werden soll als
	 *              {@link String}.
	 * @return
	 */
	public Beschriftung setTitle(String title) {
		this.title = title;
		return this;
	}

	/**
	 * The key used for storing a short <code>String</code> description for the
	 * action, used for tooltip text.
	 * 
	 * @return gibt {@link #shortDescription} als {@link String} zurück.
	 */
	@XmlElement
	public String getShortDescription() {
		return shortDescription;
	}

	/**
	 * @param shortDescription d. {@link #getShortDescription()}, d. gesetzt werden
	 *                         soll als {@link String}.
	 */
	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}
	// ComponentBeschrifter.deWhiteSpace(shortDescription)

//	public String getMnemonic() {
//		if (hasMnemonic()) {
//			return KeyEvent.getKeyText(mnemonic);
//		} else
//			return null;
//	}

//	public void setMnemonic(String chars) {
//		if (chars != null && !chars.isEmpty()) {
//			setMnemonic(KeyEvent.getExtendedKeyCodeForChar(chars.charAt(0)));
//		} else
//			setMnemonic(0);
//	}

	/**
	 * Die Methode prüft, ob ein {@link #getMnemonic()} vorhanden ist.
	 * 
	 * @return ob ein {@link #getMnemonic()} vorliegt.
	 */
	public boolean hasMnemonic() {
		return getMnemonic() != 0;
	}

	/**
	 * Speichert das Tastaturkürzel für das beschriftete Element als {@link String}
	 * (da {@link JAXB} nicht mit {@link Character} bzw. char umgehen kann). Java
	 * geht in {@link KeyEvent#getKeyCode()} eigentlich von {@link Integer}-Werten
	 * aus. Während die durch Konstanten (etwa {@link KeyEvent#VK_A}) im Java-Code
	 * recht gut zu lesen sind, würden im XML-Code nur Zahlenwerte stehen. Deshalb
	 * wird die Char gespeichert.
	 * 
	 * Siehe auch {@link #mnemonicIntValue()}, um direkt den int-Wert zu erhalten.
	 * 
	 * @return gibt {@link #mnemonic} als {@link Integer} zurück.
	 */
	@XmlAttribute(name = "mnemonicChar")
	@XmlJavaTypeAdapter(VKAdapter.class)
	public Integer getMnemonic() {
		return mnemonic;
	}

	/**
	 * Siehe {@link #setMnemonic(int)}, um direkt den int-Wert zu setzen.
	 * 
	 * @param mnemonic d. {@link #getMnemonic}, d. gesetzt werden soll als
	 *                 {@link String}.
	 */
	public void setMnemonic(Integer mnemonic) {
		this.mnemonic = mnemonic;
	}
}