package eu.gronos.beschriftungen.model;

import java.awt.GridBagConstraints;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * 
 */
public class FillAdapter extends XmlAdapter<String, Integer> {
	private static final Map<String, Integer> map = new HashMap<>();

	static {
		map.put("NONE", GridBagConstraints.NONE);
		map.put("HORIZONTAL", GridBagConstraints.HORIZONTAL);
		map.put("VERTICAL", GridBagConstraints.VERTICAL);
		map.put("BOTH", GridBagConstraints.BOTH);
	}

	@Override
	public Integer unmarshal(String v) {
		return map.getOrDefault(v, GridBagConstraints.NONE);
	}

	@Override
	public String marshal(Integer v) {
		for (Map.Entry<String, Integer> entry : map.entrySet()) {
			if (entry.getValue().equals(v)) {
				return entry.getKey();
			}
		}
		return "NONE";
	}
}
