package eu.gronos.beschriftungen.model;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * Bei manchen {@link JComponent}s kann die horizontale und/oder vertikale
 * Ausrichtung gesetzt werden.
 */
public class Gerichtet {

	/**
	 * Bei einem {@link JLabel} kann die horizontale Ausrichtung gespeichert werden
	 * {@link JLabel#getHorizontalAlignment()}, also {@link SwingConstants#RIGHT},
	 * {@link SwingConstants#LEFT} oder ähnliche
	 * 
	 */
	@XmlAttribute
	@XmlJavaTypeAdapter(AlignmentAdapter.class)
	public Integer horizontal;

	/**
	 * Bei einem {@link JLabel} kann die vertikale Ausrichtung gespeichert werden
	 * {@link JLabel#getVerticalAlignment()}, also {@link SwingConstants#TOP} oder
	 * so
	 */
	@XmlAttribute
	@XmlJavaTypeAdapter(AlignmentAdapter.class)
	public Integer vertical;
}