/*
 * IntervallUnBeschriftung.java
 * eu.gronos.kostenrechner.model.beschriftungen (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import javax.swing.JSlider;
import javax.xml.bind.annotation.XmlAttribute;

/**
 * Eine {@link UnBeschriftung} für {@link JSlider}, der Werte für
 * {@link JSlider#getMinimum()}, {@link JSlider#getMaximum()},
 * {@link JSlider#getMinorTickSpacing()} und
 * {@link JSlider#getMajorTickSpacing()} vorhält.
 *
 * @author Peter Schuster (setrok)
 * @date 19.03.2020
 *
 */
public class IntervallUnBeschriftung extends UnBeschriftung {
	private static final long serialVersionUID = 3282772228534823921L;
	private int minimum, maximum, minorTick, majorTick;

	public IntervallUnBeschriftung() {
		super();
	}

	/**
	 * @return gibt {@link #minimum} als {@link int} zurück, also Werte für
	 *         {@link JSlider#getMinimum()}.
	 */
	@XmlAttribute(name = "min")
	public int getMinimum() {
		return minimum;
	}

	/**
	 * @param minimum d. {@link #minimum}, d. gesetzt werden soll als {@link int}.
	 */
	public void setMinimum(int minimum) {
		this.minimum = minimum;
	}

	/**
	 * @return gibt {@link #maximum} als {@link int} zurück, also Werte für
	 *         {@link JSlider#getMaximum()}.
	 */
	@XmlAttribute(name = "max")
	public int getMaximum() {
		return maximum;
	}

	/**
	 * @param maximum d. {@link #maximum}, d. gesetzt werden soll als {@link int}.
	 */
	public void setMaximum(int maximum) {
		this.maximum = maximum;
	}

	/**
	 * @return gibt {@link #minorTick} als {@link int} zurück, also Werte für
	 *         {@link JSlider#getMinorTickSpacing()}
	 */
	@XmlAttribute(name = "minTick")
	public int getMinorTick() {
		return minorTick;
	}

	/**
	 * @param minorTick d. {@link #minorTick}, d. gesetzt werden soll als
	 *                  {@link int}.
	 */
	public void setMinorTick(int minorTick) {
		this.minorTick = minorTick;
	}

	/**
	 * @return gibt {@link #majorTick} als {@link int} zurück, also Werte für
	 *         {@link JSlider#getMajorTickSpacing()}
	 */
	@XmlAttribute(name = "majTick")
	public int getMajorTick() {
		return majorTick;
	}

	/**
	 * @param majorTick d. {@link #majorTick}, d. gesetzt werden soll als
	 *                  {@link int}.
	 */
	public void setMajorTick(int majorTick) {
		this.majorTick = majorTick;
	}

}
