/*
 * LangBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import java.awt.event.ActionEvent;
import java.net.URL;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import eu.gronos.beschriftungen.interfaces.Bebildert;

/**
 * von Beschriftung abgeleitete Klasse „LangBeschriftung“ mit dem zusätzlichen
 * Feld String/Element longDescription (XmlElement) und ggfs URL img
 * (XmlAttribute). Nicht den Shortkey, auch nicht den AcceleratorKey, das ist
 * jeweils ein int und wäre bei einem Export dann nur noch eine Zahl (aber auch
 * zentral sammeln). JButton und Action haben dieselbe ID
 *
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class LangBeschriftung extends Beschriftung implements Bebildert {
	private static final long serialVersionUID = 2299722526230365280L;
	private String longDescription = null;
	private String actionCommandKey = null;
	private TastenKombination acceleratorKey = null;
	private String image;

	/**
	 * The key used for storing a longer <code>String</code> description for the
	 * action, could be used for context-sensitive help.
	 * 
	 * @return gibt {@link #longDescription} als {@link String} zurück.
	 */
	@XmlElement
	public String getLongDescription() {
		return longDescription;
	}

	/**
	 * @param longDescription d. {@link #getLongDescription()}, d. gesetzt werden
	 *                        soll als {@link String}.
	 */
	public void setLongDescription(String longDescription) {
		if (longDescription != null)
			this.longDescription = longDescription.trim().replaceAll("\\s+", " ");
		else
			this.longDescription = null;
	}

	/**
	 * 
	 * @return gibt {@link #actionCommandKey} als {@link String} zurück.
	 *         ({@link javax.swing.Action#ACTION_COMMAND_KEY}) The key used to
	 *         determine the command String for the {@link ActionEvent} that will be
	 *         created when an {@link Action} is going to be notified as the result
	 *         of residing in a Keymap associated with a {@link JComponent}.
	 */
	@XmlAttribute(name = "key")
	public String getActionCommandKey() {
		return actionCommandKey;
	}

	/**
	 * @param actionCommandKey d. {@link #getActionCommandKey()}, d. gesetzt werden
	 *                         soll als {@link String}.
	 */
	public void setActionCommandKey(String actionCommandKey) {
		this.actionCommandKey = actionCommandKey;
	}

	/**
	 * The key used for storing an <code>Icon</code>. This is typically used by
	 * buttons, such as <code>JButton</code> and <code>JToggleButton</code>.
	 * 
	 * @return gibt {@link #image} als {@link String} zurück, denn {@link URL} geht
	 *         nicht.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Bebildert#getImage()
	 */
	@XmlAttribute(name = "img")
	public String getImage() {
		return image;
	}

	/**
	 * @param img d. {@link #image}, d. gesetzt werden soll als {@link String}.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Bebildert#setImage(java.lang.String)
	 */
	public void setImage(String img) {
		this.image = img;
	}

	/**
	 * @return gibt {@link #acceleratorKey} als {@link TastenKombination} zurück.
	 */
	@XmlElement(name = "accelerator")
	public TastenKombination getAcceleratorKey() {
		return acceleratorKey;
	}

	/**
	 * @param acceleratorKey d. {@link #acceleratorKey}, d. gesetzt werden soll als
	 *                       {@link TastenKombination}.
	 */
	public void setAcceleratorKey(TastenKombination acceleratorKey) {
		this.acceleratorKey = acceleratorKey;
	}

	@Override
	public String toString() {
		return String.format(
				"LangBeschriftung [id()=%s, title()=%s, actionCommandKey=%s, shortDescription()=%s, longDescription=%s, image=%s]",
				getId(), getTitle(), actionCommandKey, getShortDescription(), longDescription, image);
	}
}
