/*
 * LangVorsorgeBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import java.util.ArrayList;
import java.util.List;

import javax.swing.Action;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.beschriftungen.interfaces.Vorsorgend;

/**
 * Eine von {@link LangVorsorgeBeschriftung} abgeleitete Klasse mit einer
 * List<String> alternateTitles und auch alternateDescriptions für Elemente, die
 * ihre Beschriftung zwischendurch wechseln, vorsorgend weil es eine Reserve an
 * Strings hat
 * 
 * @author Peter Schuster (setrok)
 * @date 05.08.2019
 *
 */
public class LangVorsorgeBeschriftung extends LangBeschriftung implements Vorsorgend<LangVorsorgeBeschriftung> {
	private static final long serialVersionUID = -2627581964285739761L;
	/*
	 * Die Listen müssen je einmal angelegt werden, sonst hat der Unmarshaller
	 * Probleme
	 */
	private List<String> alternativeTitles = new ArrayList<String>();
	private List<String> alternativeDescriptions = new ArrayList<String>();
	private boolean formatted = false;

	/**
	 * 
	 * @return gibt {@link #alternativeTitles} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Titel, die die {@link Action} in
	 *         anderen Zuständen tragen kann.
	 */
	@Override
	@XmlElements({ @XmlElement(name = "alternativeTitle", type = String.class) })
	public List<String> getAlternativeTitles() {
		return alternativeTitles;
	}

	/**
	 * @param alternativeTitles d. {@link #alternativeTitles}, d. gesetzt werden
	 *                          soll als {@link List}&lt;{@link String}&gt;.
	 */
	@Override
	public void setAlternativeTitles(List<String> alternativeTitles) {
		this.alternativeTitles = new ArrayList<String>();
		for (String title : alternativeTitles) {
			this.alternativeTitles.add(title);
		}
	}

	/**
	 * @return gibt {@link #alternativeDescriptions} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Beschreibungen, die die {@link Action}
	 *         in anderen Zuständen tragen kann.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#getAlternativeDescriptions()
	 */
	@Override
	@XmlElements({ @XmlElement(name = "alternativeDescription", type = String.class) })
	public List<String> getAlternativeDescriptions() {
		return alternativeDescriptions;
	}

	/**
	 * @param alternativeDescriptions d. {@link #getAlternativeDescriptions}, d.
	 *                                gesetzt werden soll als
	 *                                {@link List}&lt;{@link String}&gt;.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#setAlternativeDescriptions(java.util.List)
	 */
	@Override
	public void setAlternativeDescriptions(List<String> alternativeDescriptions) {
		this.alternativeDescriptions = new ArrayList<String>();// LinkedList
		for (String description : alternativeDescriptions) {
			this.alternativeDescriptions.add(description);
		}
	}

	/**
	 * @return gibt als {@link boolean} zurück, also ob die
	 *         {@link #getAlternativeTitles()} den {@link Beschriftung#getTitle()}
	 *         mit {@link String#format(String, Object...)} bilden sollen.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#isFormatted()
	 */
	@Override
	@XmlAttribute(name = "formatted")
	public boolean isFormatted() {
		return formatted;
	}

	/**
	 * @param formatted d. {@link #formatted}, d. gesetzt werden soll als
	 *                  {@link Boolean}.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#setFormatted(boolean)
	 */
	@Override
	public void setFormatted(boolean formatted) {
		this.formatted = formatted;
	}

}
