/*
 * NameMap.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXB;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;

/**
 * Beschriftungen in HashMap oä organisieren, damit man alles über die id
 * abrufen kann.
 */
public class NameContainerMap extends HashMap<Integer, NameContainer> {
	private static final long serialVersionUID = 8156338816766505017L;
	public static long start;
	public static long end;

	public NameContainerMap() {
		super();
	}

	/**
	 * Konstruktor mit ressource
	 * 
	 * @param dateiname "resources/beschriftungen.xml"
	 */
	public NameContainerMap(String dateiname) {
		super();
		initFromFile(dateiname);
	}

	/**
	 * Die Methode liest die XML-Datei und konvertiert sie in eine {@link Map}
	 * mittels {@link NameContainerMapWrapper} und {@link NameContainerMapAdapter}.
	 * 
	 * @param dateiname den Dateinamen für
	 *                  {@link ClassLoader#getResourceAsStream(String)}
	 */
	private void initFromFile(String dateiname) {
		start = Kostenrechner.systemDefaultZone.millis();

		InputStream stream = getClass().getClassLoader().getResourceAsStream(dateiname);
		if (stream == null)
			throw new NullPointerException(
					String.format("Der InputStream für '%s' ist null, Datei nicht vorhanden?", dateiname));

		try {
			NameContainerMapWrapper wrap = JAXB.unmarshal(stream, NameContainerMapWrapper.class);
			NameContainerMapAdapter adapter = new NameContainerMapAdapter();
			NameContainerMap map = adapter.unmarshal(wrap);
			putAll(map);
		} catch (Throwable error) {
			FehlerHelper.zeigeFehler("Fehler beim Einlesen der Oberflächenbeschriftung!", error);
		}

		end = Kostenrechner.systemDefaultZone.millis();
	}
}