/*
 * StringConfigSchluessel.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAttribute;

import eu.gronos.beschriftungen.util.StringConfigOption;
import eu.gronos.kostenrechner.util.system.LizenzConfigOption;

/**
 * Von {@link ConfigSchluessel} abgeleitetes Parameter-Objekt für
 * {@link StringConfigOption} und {@link LizenzConfigOption}
 * 
 * @author Peter Schuster (setrok)
 * @date 31.01.2020
 */
public class StringConfigSchluessel extends ConfigSchluessel<String> {

	/**
	 * @param schluessel   der Schlüssel im Unterast
	 *                     <code>"/eu/gronos/kostentenor"</code> (String)
	 * @param standardWert der Standard-Wert, falls der Schlüssel noch nicht
	 *                     angelegt ist.
	 * 
	 */
	public StringConfigSchluessel(String schluessel, String standardWert) {
		super(schluessel, standardWert);
	}

	/**
	 * Konstruktor für {@link JAXB}
	 * 
	 */
	public StringConfigSchluessel() {
		super();
	}

	/**
	 * @return gibt {@link #standardWert} als {@link String} zurück, das ist der
	 *         Standard-Wert als {@link String}, falls der Schlüssel noch nicht
	 *         angelegt ist.
	 */
	@Override
	@XmlAttribute(name = "standard")
	public String getStandardWert() {
		return standardWert;
	}

	/**
	 * @param standardWert d. {@link #standardWert}, d. gesetzt werden soll als
	 *                     {@link String}.
	 */
	@Override
	public void setStandardWert(String standardWert) {
		this.standardWert = standardWert;
	}
}