package eu.gronos.beschriftungen.model;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;

public class VKAdapter extends XmlAdapter<String, Integer> {

	private static final Map<String, Integer> map = new HashMap<>();
	private static final Map<Integer, String> reverse = new HashMap<>();

	static {
		// Buchstaben A–Z
		map.put("A", KeyEvent.VK_A);
		map.put("B", KeyEvent.VK_B);
		map.put("C", KeyEvent.VK_C);
		map.put("D", KeyEvent.VK_D);
		map.put("E", KeyEvent.VK_E);
		map.put("F", KeyEvent.VK_F);
		map.put("G", KeyEvent.VK_G);
		map.put("H", KeyEvent.VK_H);
		map.put("I", KeyEvent.VK_I);
		map.put("J", KeyEvent.VK_J);
		map.put("K", KeyEvent.VK_K);
		map.put("L", KeyEvent.VK_L);
		map.put("M", KeyEvent.VK_M);
		map.put("N", KeyEvent.VK_N);
		map.put("O", KeyEvent.VK_O);
		map.put("P", KeyEvent.VK_P);
		map.put("Q", KeyEvent.VK_Q);
		map.put("R", KeyEvent.VK_R);
		map.put("S", KeyEvent.VK_S);
		map.put("T", KeyEvent.VK_T);
		map.put("U", KeyEvent.VK_U);
		map.put("V", KeyEvent.VK_V);
		map.put("W", KeyEvent.VK_W);
		map.put("X", KeyEvent.VK_X);
		map.put("Y", KeyEvent.VK_Y);
		map.put("Z", KeyEvent.VK_Z);

		// Ziffern 0–9
		map.put("0", KeyEvent.VK_0);
		map.put("1", KeyEvent.VK_1);
		map.put("2", KeyEvent.VK_2);
		map.put("3", KeyEvent.VK_3);
		map.put("4", KeyEvent.VK_4);
		map.put("5", KeyEvent.VK_5);
		map.put("6", KeyEvent.VK_6);
		map.put("7", KeyEvent.VK_7);
		map.put("8", KeyEvent.VK_8);
		map.put("9", KeyEvent.VK_9);

		// Funktionstasten F1–F12
		map.put("F1", KeyEvent.VK_F1);
		map.put("F2", KeyEvent.VK_F2);
		map.put("F3", KeyEvent.VK_F3);
		map.put("F4", KeyEvent.VK_F4);
		map.put("F5", KeyEvent.VK_F5);
		map.put("F6", KeyEvent.VK_F6);
		map.put("F7", KeyEvent.VK_F7);
		map.put("F8", KeyEvent.VK_F8);
		map.put("F9", KeyEvent.VK_F9);
		map.put("F10", KeyEvent.VK_F10);
		map.put("F11", KeyEvent.VK_F11);
		map.put("F12", KeyEvent.VK_F12);

		// Sondertasten
		map.put("ENTER", KeyEvent.VK_ENTER);
		map.put("ESCAPE", KeyEvent.VK_ESCAPE);
		map.put("BACK_SPACE", KeyEvent.VK_BACK_SPACE);
		map.put("TAB", KeyEvent.VK_TAB);
		map.put("SPACE", KeyEvent.VK_SPACE);
		map.put("SLASH", KeyEvent.VK_SLASH);
		map.put("MINUS", KeyEvent.VK_MINUS);
		map.put("COMMA", KeyEvent.VK_COMMA);
		map.put("PERIOD", KeyEvent.VK_PERIOD);
		map.put("SEMICOLON", KeyEvent.VK_SEMICOLON);
		map.put("QUOTE", KeyEvent.VK_QUOTE);
		map.put("OPEN_BRACKET", KeyEvent.VK_OPEN_BRACKET);
		map.put("CLOSE_BRACKET", KeyEvent.VK_CLOSE_BRACKET);
		map.put("BACK_SLASH", KeyEvent.VK_BACK_SLASH);
		map.put("DELETE", KeyEvent.VK_DELETE);

		// Modifizierer (optional)
		map.put("SHIFT", KeyEvent.VK_SHIFT);
		map.put("CONTROL", KeyEvent.VK_CONTROL);
		map.put("ALT", KeyEvent.VK_ALT);
		map.put("META", KeyEvent.VK_META);

		// Umkehrabbildung
		for (Map.Entry<String, Integer> e : map.entrySet()) {
			reverse.put(e.getValue(), e.getKey());
		}
	}

	@Override
	public Integer unmarshal(String chars) {
		if (chars == null)
			return KeyEvent.VK_UNDEFINED;
		// return map.getOrDefault(chars.toUpperCase(), KeyEvent.VK_UNDEFINED);
		if (map.containsKey(chars.toUpperCase())) {
			//System.out.println("Taste vorhanden: " + chars + "(" + map.get(chars.toUpperCase()) + ")");
			return map.get(chars.toUpperCase());
		} else if (chars.trim().length() == 1) {// !chars.isEmpty()
			// hier den Rest für extendedKeyCodes
			//System.out.println("Erweiterte Taste: " + chars);
			return KeyEvent.getExtendedKeyCodeForChar(chars.charAt(0));
//		} else if (chars.length() > 1) {
//			return KeyStroke.getKeyStroke(chars).getKeyCode();
		} else {
			System.out.println("UNDEFINED");
			return KeyEvent.VK_UNDEFINED;
		}
	}

	@Override
	public String marshal(Integer v) {
		if (v == null)
			return "UNDEFINED";
		return reverse.getOrDefault(v, "UNDEFINED");
	}
}