/*
 * VorsorgendeBeschriftung.java
 * eu.gronos.kostenrechner.model (Kostenrechner)
 */
package eu.gronos.beschriftungen.model;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

import eu.gronos.beschriftungen.interfaces.Vorsorgend;

/**
 * von Beschriftung abgeleitete Klasse „VorsorgendeBeschriftung“ mit einer
 * List<String> alternateTitles (XmlElements/Wrapper) und vielleicht auch
 * alternateDescriptions (XmlElements/Wrapper?) für Elemente, die ihre
 * Beschriftung zwischendurch wechseln, vorsorgend weil es eine Reserve an
 * Strings hat, Wenn ein JLabel zwischendurch geändert wird, zweite Beschriftung
 * speichern, nein besser: Alternativen mitspeichern in VorsorgendeBeschriftung,
 * s.o.
 * 
 * @author Peter Schuster (setrok)
 * @date 03.08.2019
 *
 */
public class VorsorgendeBeschriftung extends Beschriftung implements Vorsorgend<VorsorgendeBeschriftung> {
	private static final long serialVersionUID = 7551783095558692578L;
	/* Die Liste muss einmal angelegt werden, sonst hat der Unmarshaller Probleme */
	private List<String> alternativeTitles = new ArrayList<String>();
	private List<String> alternativeDescriptions = new ArrayList<String>();
	private boolean formatted = false;

	/**
	 * @return gibt {@link #alternativeTitles} als
	 *         {@link List}&lt;{@link String}&gt; zurück. Das ist eine vorsorgend
	 *         bereitgehaltene Liste anderer Titel, die die {@link JComponent} in
	 *         anderen Zuständen tragen kann.
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#getAlternativeTitles()
	 */
	@Override
	@XmlElements({ @XmlElement(name = "alternativeTitle", type = String.class) })
	public List<String> getAlternativeTitles() {
		return alternativeTitles;
	}

	/**
	 * @param alternativeTitles d. {@link #alternativeTitles}, d. gesetzt werden
	 *                          soll als {{@link List}&lt;{@link String}&gt;.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#setAlternativeTitles(java.util.List)
	 */
	@Override
	public void setAlternativeTitles(List<String> alternativeTitles) {
		this.alternativeTitles = new ArrayList<String>();// LinkedList
		for (String title : alternativeTitles) {
			this.alternativeTitles.add(title);
		}
	}

	/**
	 * @return gibt {@link #alternativeDescriptions} als {@link List<String>}
	 *         zurück. Das ist eine vorsorgend bereitgehaltene Liste anderer
	 *         Beschreibungen, die die {@link JComponent} in anderen Zuständen
	 *         tragen kann.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#getAlternativeDescriptions()
	 */
	@Override
	@XmlElements({ @XmlElement(name = "alternativeDescription", type = String.class) })
	public List<String> getAlternativeDescriptions() {
		return alternativeDescriptions;
	}

	/**
	 * @param alternativeDescriptions d. {@link #getAlternativeDescriptions}, d.
	 *                                gesetzt werden soll als
	 *                                {@link List}&lt;String&gt;.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#setAlternativeDescriptions(java.util.List)
	 */
	@Override
	public void setAlternativeDescriptions(List<String> alternativeDescriptions) {
		this.alternativeDescriptions = new ArrayList<String>();// LinkedList
		for (String description : alternativeDescriptions) {
			this.alternativeDescriptions.add(description);
		}
	}

	/**
	 * @return gibt als {@link boolean} zurück, also ob die
	 *         {@link #getAlternativeTitles()} den {@link Beschriftung#getTitle()}
	 *         mit {@link String#format(String, Object...)} bilden sollen.
	 * 
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#isFormatted()
	 */
	@Override
	@XmlAttribute(name="formatted")
	public boolean isFormatted() {
		return formatted;
	}

	/**
	 * @param formatted d. {@link #formatted}, d. gesetzt werden soll als
	 *                  {@link boolean}.
	 *                  
	 * @see eu.gronos.beschriftungen.interfaces.Vorsorgend#setFormatted(boolean)
	 */
	@Override
	public void setFormatted(boolean formatted) {
		this.formatted = formatted;
	}

}
