package eu.gronos.beschriftungen.view;

import java.awt.Container;
import java.awt.LayoutManager;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.model.Beschriftung;

/**
 * Abstrakte Oberklasse, von denen die Klassen für die Registerkarten abgeleitet
 * werden können.
 */
public class BeschriebenesPanel extends JPanel {

	private static final long serialVersionUID = -1749827701257975562L;
	protected final ComponentBeschrifter beschrifter = new ComponentBeschrifter();

	public BeschriebenesPanel() {
		super();
	}

	public BeschriebenesPanel(LayoutManager layout) {
		super(layout);
	}

	public BeschriebenesPanel(boolean isDoubleBuffered) {
		super(isDoubleBuffered);
	}

	public BeschriebenesPanel(LayoutManager layout, boolean isDoubleBuffered) {
		super(layout, isDoubleBuffered);
	}

	/**
	 * Die Methode baut ein {@link JPanel} mit {@link TitledBorder} in
	 * Seperatorfarbe.
	 * 
	 * @param beschriftung eine {@link Beschriftung} für das {@link JPanel} selbst
	 * @param layout       {@link LayoutManager} This method changes layout-related
	 *                     information, and therefore, invalidates the component
	 *                     hierarchy.
	 * @return das {@link JPanel}
	 */
	protected JPanel createPanel(Beschriftung beschriftung, LayoutManager layout) {
		JPanel panel = new JPanel();
		panel.setLayout(layout);
		Border schwarz = BorderFactory
				.createLineBorder(UIManager.getLookAndFeel().getDefaults().getColor("Button.shadow"));
		TitledBorder brdr = BorderFactory.createTitledBorder(schwarz);
		panel.setBorder(brdr);
		beschrifter.beschrifte(panel, beschriftung);
		return panel;
	}

	/**
	 * Die Methode baut über {@link #createPanel(Beschriftung, LayoutManager)} ein
	 * {@link JPanel} mit {@link TitledBorder} in Seperatorfarbe und fügt das ganze
	 * dann noch in einen {@link Container} ein.
	 * 
	 * @param beschriftung eine {@link Beschriftung} für das {@link JPanel} selbst
	 * @param layout       {@link LayoutManager} This method changes layout-related
	 *                     information, and therefore, invalidates the component
	 *                     hierarchy.
	 * @return das erstellte {@link JPanel}
	 */
	protected JPanel addNewPanel(Beschriftung beschriftung, LayoutManager layout) {//, Container behaelter
		return (JPanel) beschrifter.add(createPanel(beschriftung, layout), beschriftung, this);
	}

}