/*
 * PopUpMenuBuilder.java
 * eu.gronos.kostenrechner.view.gebuehren (Kostenrechner)
 */
package eu.gronos.beschriftungen.view;

import java.util.Arrays;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

import eu.gronos.beschriftungen.ComponentBeschrifter;
import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.Beschriftung;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.controller.KontextMouseListener;

/**
 * Die Klasse baut {@link JPopupMenu}s aus {@link BeschriebeneAktion}en.
 *
 * @author Peter Schuster (setrok)
 * @date 12.08.2019
 *
 */
public class PopupMenuBuilder {

	/**
	 * Die Methode baut ein {@link JPopupMenu} aus {@link BeschriebeneAktion}en.
	 * 
	 * @param beschriftung die {@link Beschriftung} für das Menu selbst und den
	 *                     ersten Eintrag mit dem Titel
	 * @param comp         die {@link JComponent}, {@link JTable} oder
	 *                     {@link JEditorPane}, zu dem das Kontextmenu gehört
	 * @param seperators   ein Array mit den Positionen der Trennstriche
	 * @param actions      ein varArg aus {@link BeschriebeneAktion}, die in der
	 *                     übergegebenen Reihenfolge MenuItems des Kontextmenü
	 *                     werden sollen.
	 * @return ein {@link JPopupMenu}
	 */ 
	public JPopupMenu build(Beschriftung beschriftung, JComponent comp, Integer[] seperators,
			BeschriebeneAktion... actions) {
		JPopupMenu pop = new JPopupMenu(beschriftung.getTitle());
		final JMenuItem menuItem = new JMenuItem();
		if (beschriftung == null || beschriftung.getTitle() == null) {
			System.out.println("Beschriftung null!");
		}
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();

		beschrifter.beschrifte(pop, beschriftung);
		beschrifter.beschrifte(menuItem, beschriftung);
		pop.add(menuItem);
		for (int index = 0; index < actions.length; index++) {
			if (Arrays.asList(seperators).contains(Integer.valueOf(index + 1)))
				pop.addSeparator();

			BeschriebeneAktion action= actions[index];
			pop.add(action.toMenuItem());

			if (comp.getActionMap() != null) {
				final LangBeschriftung langBeschriftung = action.getBeschriftung();
				final String actionCommandKey = langBeschriftung.getActionCommandKey();
				comp.getActionMap().put(actionCommandKey, action);
				if (comp.getInputMap() != null && langBeschriftung.getAcceleratorKey() != null) {
					comp.getInputMap().put(langBeschriftung.getAcceleratorKey().toKeyStroke(), actionCommandKey);
				}
			} else
				System.out.println("ActionMap ist null!");
		}
		if (comp instanceof JTable)
			comp.addMouseListener(new KontextMouseListener((JTable) comp, pop));
		else
			comp.addMouseListener(new KontextMouseListener(pop));
		return pop;
	}

	public void printActionMap(JComponent comp) {
		if (comp.getActionMap() != null) {
			ActionMap map = comp.getActionMap();
			for (Object o : map.allKeys()) {
				Action a = map.get(o);
				System.out.println(String.format("Key: %s; Action: %s", o.toString(), a.toString()));
			}
		}
	}

}