/*
 * HinzufuegenOkAction.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;

/**
 * Die {@link Action} dient der OK-Schaltfläche; Sie setzt das OK-Field auf wahr
 * und schließt das Fenster.
 *
 * @author Peter Schuster (setrok)
 * @date 5 Mar 2019
 *
 */
public class HinzufuegenOkAction<E> extends BeschriebeneAktion {
	private final HinzufuegenDialog<E> dialog;
	private static final long serialVersionUID = -5819524266780763824L;

	/**
	 * Konstruktor.
	 * 
	 * @param dialog       Verweis auf {@link HinzufuegenDialog}
	 * @param beschreibung eine {@link LangBeschriftung} mit {@link Action#NAME}
	 *                     {@link Action#SHORT_DESCRIPTION}
	 *                     {@link Action#MNEMONIC_KEY}
	 *                     {@link Action#ACTION_COMMAND_KEY}
	 *                     {@link Action#ACCELERATOR_KEY}
	 */
	public HinzufuegenOkAction(HinzufuegenDialog<E> dialog, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.dialog = dialog;
		Kostenrechner.getLogger().info("Action gebaut");
	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		if (dialog.parseEingabe()) {
			dialog.setOk(true);
			dialog.setVisible(false);
			dialog.dispose();
		} else
			return;
	}
}