/*
 * TabulatorBeforeAction.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JTable;

/**
 * AbstractAction, die verhindert, dass die {@link JTable} Umsch+Tabulartortaste
 * "frisst".
 *
 * @author Peter Schuster (setrok)
 * @date 5 May 2019
 * 
 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
 *
 */
public class TabulatorBeforeAction extends AbstractAction {
	private static final long serialVersionUID = -244188598744791079L;

	public void actionPerformed(ActionEvent ae) {
		KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
	}
}