/**
 * AssistentBkStreitwertHorcher.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import eu.gronos.kostenrechner.view.baumbach.SimpleBeteiligtenTable;

/**
 * Der Horcher muss auf Änderungen reagieren: Wenn selected, dann das Textfeld
 * aktivieren und Table deaktivieren; wenn nicht selected, dann umgekehrt.
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class AssistentBkStreitwertHorcher implements ChangeListener {
	private final JFormattedTextField textField;
	private final SimpleBeteiligtenTable table;

	/**
	 * @param textField ein {@link JFormattedTextField}
	 * @param table     die korrespondierende {@link SimpleBeteiligtenTable}
	 */
	public AssistentBkStreitwertHorcher(JFormattedTextField textField, SimpleBeteiligtenTable table) {
		this.textField = textField;
		this.table = table;
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		boolean b = ((JCheckBox) e.getSource()).isSelected();
		textField.setEnabled(b);
		table.setEnabled(!b);
	}
}