/**
 * AssistentWiderklageEinheitlichHorcher.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import eu.gronos.kostenrechner.model.baumbach.ProtoBeteiligtenWerte;
import eu.gronos.kostenrechner.view.baumbach.SimpleBeteiligtenTable;

/**
 * Horcher für eine {@link JCheckBox}, damit sie sich so verhält:
 * 
 * Muss auf Änderungen so reagieren, dass entweder das Textfeld aktiviert werden
 * muss (bei isSelected(true)) oder die beiden Tabellen (bei isSelected(false))
 * - die jeweils andere Gruppe muss dann deaktiv werden.
 * 
 * Die Klägertabelle muss unveränderlich sein, wenn der Kläger nicht involviert
 * ist.
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class AssistentWbkStreitwertHorcher implements ChangeListener {
	private final JFormattedTextField textField;
	private final SimpleBeteiligtenTable klTable;
	private final SimpleBeteiligtenTable dwbkTable;
	private final ProtoBeteiligtenWerte sonstigeWerte;

	public AssistentWbkStreitwertHorcher(JFormattedTextField textField, SimpleBeteiligtenTable klTable,
			SimpleBeteiligtenTable dwbkTable, ProtoBeteiligtenWerte sonstigeWerte) {
		this.textField = textField;
		this.klTable = klTable;
		this.dwbkTable = dwbkTable;
		this.sonstigeWerte = sonstigeWerte;
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		boolean b = ((JCheckBox) e.getSource()).isSelected();
		textField.setEnabled(b);
		textField.setText(sonstigeWerte.wkStreitwert.toString());//(Double.toString(sonstigeWerte.wkStreitwert));
		if (sonstigeWerte.klWk)
			klTable.setEnabled(!b);
		else
			klTable.setEnabled(false);
		dwbkTable.setEnabled(!b);
		if (!b)
			textField.setText("");
	}
}