/**
 * StreitgenossenGesamtschuldExtractAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.data.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die {@link Action} geht nach Beteiligtentypen aufgeteilt durch die
 * Beteiligten einer Tabelle, bestimmt den gesamtschuldnerischen Sockelbetrag,
 * erzeugt dann eine {@link BaumbachGesamtschuldnerschaft} und zieht von allen
 * Beteiligten diesen Sockelbetrag ab. {@link KeyEvent#VK_V}
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenGesamtschuldBkExtractAction extends BeschriebeneAktion {
	private final StreitgenossenTabellenBehandelnd handler;
	private static final long serialVersionUID = -2835734772816646654L;

	/**
	 * Konstruktor.
	 * 
	 * @param handler  {@link StreitgenossenPanel} als
	 *                 {@link StreitgenossenTabellenBehandelnd}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenGesamtschuldBkExtractAction(StreitgenossenTabellenBehandelnd handler,
			LangBeschriftung beschriftung) {
		super(beschriftung);
		this.handler = handler;
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		BeteiligtenTableModel btm = handler.getTableModel(BeteiligtenTyp.BEKLAGTE.ordinal());// btmBeklagte;
		// TODO ALLES PRÜFEN!
		BaumbachBeteiligtenListe beteiligte = btm.getAllValues();
		if (beteiligte == null || beteiligte.size() < 2) {
			return;
		}
		BaumbachGesamtschuldnerschaft gesamtschuldnerschaft = beteiligte
				.extrahiereGesamtschuldnerschaft(btm.getBeteiligtenTyp());
		if (gesamtschuldnerschaft != null) {
			btm.addRow(gesamtschuldnerschaft);
			// Rekursion, sofern Rückgabe nicht null
			actionPerformed(event);
			// Und das Model muss was von der Änderung mitbekommen.
			btm.fireTableDataChanged();
		} else {
			Kostenrechner.getLogger().info("Schleife endet!");
		}
	}
}