/**
 * StreitgenossenWiderklageAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.data.baumbach.Widerklage;
import eu.gronos.kostenrechner.data.tenordaten.Beteiligter.BeteiligtenTyp;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.baumbach.WiderklageHinzufuegenDialog;

/**
 * Die {@link Action} ruft einen kleinen {@link HinzufuegenDialog} der Klasse
 * {@link WiderklageHinzufuegenDialog} für die Widerklage auf.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenWiderklageAction extends BeschriebeneAktion
		implements AbfrageLieferant<WiderklageHinzufuegenDialog> {
	private final StreitgenossenTabellenBehandelnd panel;
	private static final long serialVersionUID = 7753262660993032427L;
	private final WiderklageHinzufuegenDialog dialog;

	/**
	 * Konstruktor.
	 * 
	 * @param panel    {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenWiderklageAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
		dialog = new WiderklageHinzufuegenDialog(panel.getKostenrechner());
	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		Widerklage widerklage = dialog.showDialogAndAsk();
		if (widerklage == null)
			return;
		panel.setWiderKlageAnzeigen(widerklage.isVorhanden());
		panel.getTableModel(BeteiligtenTyp.KLAEGER.ordinal()).setWiderKlageAnzeigen(widerklage.isVorhanden());// btmKlaeger
		panel.getTableModel(BeteiligtenTyp.DRITTWIDERBEKLAGTE.ordinal()).setWiderKlageAnzeigen(widerklage.isVorhanden());// btmDrittwiderbeklagte
		panel.getTableModel(BeteiligtenTyp.BEKLAGTE.ordinal()).setWiderKlageAnzeigen(widerklage.isVorhanden());// btmBeklagte
		panel.setWirtschaftlichIdentisch(widerklage.isWirtschaftlichIdentisch());
	}

	/**
	 * @return gibt den {@link WiderklageHinzufuegenDialog} zurück, den die Aktion
	 *         erstellt.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	@Override
	public WiderklageHinzufuegenDialog getDialog() {
		return dialog;
	}
}