/**
 * ForderungNeuAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.forderungen;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.data.forderungen.Forderung;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.view.forderungen.ForderungHinzufuegen;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;

/**
 * Die {@link Action} fügt über {@link ForderungHinzufuegen} ein neues Angriffs-
 * oder Verteidigungsmittel zur Tabelle hinzu
 * 
 * @author Peter Schuster (setrok)
 * @date 04.11.2018
 *
 */
public class ForderungNeuAction extends BeschriebeneAktion implements AbfrageLieferant<ForderungHinzufuegen> {
	private final ForderungsStaffelungPanel panel;
	private static final long serialVersionUID = -25587531439255593L;
	private ForderungHinzufuegen dialog;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis zum {@link ForderungsStaffelungPanel}
	 * @param beschriftung eine {@link LangBeschriftung} mit {@link Action#NAME},
	 *                     {@link Action#SHORT_DESCRIPTION},
	 *                     {@link Action#MNEMONIC_KEY} und
	 *                     {@link Action#ACTION_COMMAND_KEY}
	 */
	public ForderungNeuAction(ForderungsStaffelungPanel panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Forderung forderung = setDialog(new ForderungHinzufuegen(panel.getKostenrechner())).showDialogAndAsk();
		if (forderung != null)
			panel.ftm.addRow(forderung);
		setDialog(null);
	}

	/**
	 * @return gibt {@link #dialog} als {@link ForderungHinzufuegen} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	public ForderungHinzufuegen getDialog() {
		return dialog;
	}

	/**
	 * @param dialog d. {@link #dialog}, d. gesetzt werden soll als
	 *               {@link ForderungHinzufuegen}.
	 * @return den {@link #getDialog()}
	 */
	private ForderungHinzufuegen setDialog(ForderungHinzufuegen dialog) {
		this.dialog = dialog;
		return dialog;
	}
}