/*
 * GebuehrenBerechnungAufrufHorcher.java
 * eu.gronos.kostenrechner.controller.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.data.gebuehren.GebuehrenBerechnung;
import eu.gronos.kostenrechner.model.gebuehren.StreitwertTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;

/**
 * {@link ChangeListener}, der merkt, wenn das {@link GebuehrenBerechnungPanel}
 * das erste Mal aufgerufen wird und dann erst das {@link StreitwertTableModel}
 * lädt.
 *
 * @author Peter Schuster (setrok)
 * @date 06.01.2020
 * 
 * @url https://alvinalexander.com/blog/post/jfc-swing/detect-when-user-selects-tab-in-jtabbedpane
 *
 */
public class GebuehrenBerechnungAufrufHorcher implements ChangeListener {
	private boolean angeschaut = false;

	/**
	 * Die Methode setzt die Streitwerttabelle, wenn das
	 * {@link GebuehrenBerechnungPanel} erstmals aufgerufen wird.
	 * 
	 * @param e {@link ChangeEvent}
	 * 
	 * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
	 */
	@Override
	public void stateChanged(ChangeEvent e) {
		JTabbedPane tabSource = (JTabbedPane) e.getSource();
		if (!isAngeschaut() && GebuehrenBerechnung.TAB_ID == tabSource.getSelectedIndex()) {
			SwingUtilities.invokeLater(() -> GebuehrenBerechnungPanel.getInstance().initStreitwertTable());
			setAngeschaut(true);
			Kostenrechner.getLogger().info("Gebührenrechner erstmals angesehen!");
		}

	}

	/**
	 * @return gibt {@link #angeschaut} als {@link boolean} zurück.
	 */
	public boolean isAngeschaut() {
		return angeschaut;
	}

	/**
	 * @param angeschaut d. {@link #angeschaut}, d. gesetzt werden soll als
	 *                   {@link boolean}.
	 */
	public void setAngeschaut(boolean angeschaut) {
		this.angeschaut = angeschaut;
	}

}
