/*
 * GebuehrenDocumentHorcher.java
 * eu.gronos.kostenrechner.controller.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import eu.gronos.kostenrechner.model.gebuehren.GebuehrenListModel;

/**
 * Ein {@link DocumentListener} für das Zusammespiel zwischen einem Suchfeld als
 * {@link JTextField} und einer {@link JList} mit einem
 * {@link GebuehrenListModel}.
 *
 * @author Peter Schuster (setrok)
 * @date 16 Jun 2019
 *
 */
public class GebuehrenDocumentHorcher implements DocumentListener {

	private GebuehrenListModel model;

	/**
	 * Konstruktor mit {@link GebuehrenListModel}
	 * 
	 * @param model das {@link GebuehrenListModel}
	 */
	public GebuehrenDocumentHorcher(GebuehrenListModel model) {
		this.model = model;
	}

	/**
	 * Die Methode wird aufgerufen, wenn Teile in das {@link Document} eingefügt
	 * wurden.
	 * 
	 * @param e das {@link DocumentEvent}
	 * 
	 * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
	 */
	@Override
	public void insertUpdate(DocumentEvent e) {
		String term = getString(e);
		model.setTerm(term);
	}

	/**
	 * Die Methode wird aufgerufen, wenn Teile des {@link Document}s entfernt
	 * wurden.
	 * 
	 * @param e das {@link DocumentEvent}
	 * 
	 * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
	 */
	@Override
	public void removeUpdate(DocumentEvent e) {
		String term = getString(e);
		model.setTerm(term);

	}

	/**
	 * Die Methode wird aufgerufen, wenn sich Attribute des {@link Document}s
	 * geändert haben
	 * 
	 * @param e das {@link DocumentEvent}
	 * 
	 * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
	 */
	@Override
	public void changedUpdate(DocumentEvent e) {
		String term = getString(e);
		model.setTerm(term);
	}

	/**
	 * Die Methode zieht den Text aus dem {@link Document} des {@link JTextField}s,
	 * auf das der {@link DocumentListener} gesetzt wurde.
	 * 
	 * @param de das {@link DocumentEvent}
	 * 
	 * @return einen {@link String} für {@link GebuehrenListModel#getTerm()}
	 * @throws BadLocationException ein Teil des ausgelesen Range war im
	 *                              {@link Document} nicht gültig. In der Exception
	 *                              wird die erste Stelle zurückgegeben, die nicht
	 *                              stimmte.
	 */
	private String getString(DocumentEvent de) {
		final Document document = de.getDocument();
		try {
			return document.getText(0, document.getLength());
		} catch (BadLocationException e) {
			return "";
		}
	}

}
