/**
 * GebuehrenTabelleKopierenAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ListSelectionModel;

import eu.gronos.beschriftungen.controller.BeschriebeneAktion;
import eu.gronos.beschriftungen.model.LangBeschriftung;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;

/**
 * kopiereSwTabelle speichert eine Aktion als AbstractAction, die den Inhalt der
 * Streitwerttabelle in die Zwischenablage kopiert.
 *
 * @author Peter Schuster (setrok)
 * @date 04.11.2018
 *
 */
public class GebuehrenTabelleKopierenAction extends BeschriebeneAktion {
	private final GebuehrenBerechnungPanel panel;
	private static final long serialVersionUID = 5567272748853539208L;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis auf {@link GebuehrenBerechnungPanel}
	 * @param beschriftung eine {@link LangBeschriftung} mit {@link Action#NAME}
	 *                     {@link Action#SHORT_DESCRIPTION}
	 *                     {@link Action#MNEMONIC_KEY}
	 *                     {@link Action#ACTION_COMMAND_KEY}
	 *                     {@link Action#ACCELERATOR_KEY}
	 */
	public GebuehrenTabelleKopierenAction(GebuehrenBerechnungPanel panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}
	// , KeyEvent.VK_K, KeyStroke.getKeyStroke(KeyEvent.VK_C,
	// Kostenrechner.ctrlMask)
	// int mnemonic,,KeyStroke acceleratorKey, mnemonic, acceleratorKey
	// String name, String shortDescription,String actionCommandKey,
//		super(name, shortDescription, mnemonic, actionCommandKey, acceleratorKey);

	@Override
	public void actionPerformed(ActionEvent ae) {
		// Werte zwischenspeichern
		ListSelectionModel model = panel.getTabStreitwertTabelle().getSelectionModel();
		int selection = panel.getTabStreitwertTabelle().getSelectedRow();
		// Alles markieren
		panel.getTabStreitwertTabelle().setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
		panel.getTabStreitwertTabelle().selectAll();
		// kopieren down vote
		Action copy = panel.getTabStreitwertTabelle().getActionMap().get("copy");
		ActionEvent nev = new ActionEvent(panel.getTabStreitwertTabelle(), ActionEvent.ACTION_PERFORMED, "");
		copy.actionPerformed(nev);
		// Werte wieder zurücksetzen
		panel.getTabStreitwertTabelle().setSelectionModel(model);
		panel.getTabStreitwertTabelle().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		panel.getTabStreitwertTabelle().changeSelection(selection, -1, false, false);
	}
}